/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import com.cout970.magneticraft.block.fluids.BlockFluidClasicMg;
import com.cout970.magneticraft.block.fluids.BlockFluidHeavyOil;
import com.cout970.magneticraft.block.fluids.BlockFluidHotCrude;
import com.cout970.magneticraft.block.fluids.BlockFluidLightOil;
import com.cout970.magneticraft.block.fluids.BlockFluidNaturalGas;
import com.cout970.magneticraft.block.fluids.BlockFluidOil;
import com.cout970.magneticraft.block.fluids.BlockFluidSteam;
import com.cout970.magneticraft.handlers.FluidFuelHandler;
import com.cout970.magneticraft.util.Log;
import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.api.fuel.FuelManager;
import net.minecraft.block.Block;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class ManagerFluids {
    public static Fluid steam;
    public static Fluid oil;
    public static Fluid heavyOil;
    public static Fluid lightOil;
    public static Fluid naturalGas;
    public static Fluid hotCrude;
    public static Block steamBlock;
    public static Block oilBlock;
    public static Block lightOilBlock;
    public static Block heavyOilBlock;
    public static Block naturalGasBlock;
    public static Block hotCrudeBlock;
    public static final String STEAM_NAME = "steam";
    public static final String OIL_NAME = "oil";
    public static final String HEAVY_OIL = "heavyoil";
    public static final String LIGHT_OIL = "lightoil";
    public static final String NATURAL_GAS = "naturalgas";
    public static final String HOT_CRUDE = "hotcrude";

    public static void initFluids() {
        steam = new Fluid(STEAM_NAME).setDensity(-5000).setViscosity(1000).setTemperature(373).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)steam);
        steamBlock = new BlockFluidSteam(steam, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)steamBlock, (String)"blocksteam");
        steam.setBlock(steamBlock);
        oil = new Fluid(OIL_NAME).setDensity(800).setViscosity(1500);
        FluidRegistry.registerFluid((Fluid)oil);
        oilBlock = new BlockFluidOil(oil, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)oilBlock, (String)"blockoil");
        oil.setBlock(oilBlock);
        heavyOil = new Fluid(HEAVY_OIL).setDensity(600).setViscosity(2000);
        FluidRegistry.registerFluid((Fluid)heavyOil);
        heavyOilBlock = new BlockFluidHeavyOil(heavyOil, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)heavyOilBlock, (String)"blockheavyoil");
        heavyOil.setBlock(heavyOilBlock);
        lightOil = new Fluid(LIGHT_OIL).setDensity(300).setViscosity(1200);
        FluidRegistry.registerFluid((Fluid)lightOil);
        lightOilBlock = new BlockFluidLightOil(lightOil, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)lightOilBlock, (String)"blocklightoil");
        lightOil.setBlock(lightOilBlock);
        naturalGas = new Fluid(NATURAL_GAS).setDensity(-1000).setViscosity(1000).setGaseous(true);
        FluidRegistry.registerFluid((Fluid)naturalGas);
        naturalGasBlock = new BlockFluidNaturalGas(naturalGas, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)naturalGasBlock, (String)"blocknaturalgas");
        naturalGas.setBlock(naturalGasBlock);
        hotCrude = new Fluid(HOT_CRUDE).setDensity(800).setViscosity(1000).setTemperature(450);
        FluidRegistry.registerFluid((Fluid)hotCrude);
        hotCrudeBlock = new BlockFluidHotCrude(hotCrude, BlockFluidClasicMg.fluidMaterial);
        GameRegistry.registerBlock((Block)hotCrudeBlock, (String)"blockhotcrude");
        hotCrude.setBlock(hotCrudeBlock);
    }

    public static void registerFuels() {
        if (BuildcraftFuelRegistry.fuel == null) {
            BuildcraftFuelRegistry.fuel = new FluidFuelHandler();
            Log.info("Creating a IFuelManager");
        }
        Log.info("Registering Fuels into buildcraft fuel registry");
        BuildcraftFuelRegistry.fuel.addFuel(lightOil, 80, 25000);
        BuildcraftFuelRegistry.fuel.addFuel(heavyOil, 60, 25000);
        BuildcraftFuelRegistry.fuel.addFuel(naturalGas, 40, 75000);
        BuildcraftFuelRegistry.fuel.addFuel(oil, 30, 5000);
        Log.info("Registering Fuels into railcraft fuel manager");
        FuelManager.addBoilerFuel(lightOil, 96000);
        FuelManager.addBoilerFuel(heavyOil, 75000);
        FuelManager.addBoilerFuel(naturalGas, 150000);
        FuelManager.addBoilerFuel(oil, 7500);
    }
}

