/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.acces;

import com.cout970.magneticraft.api.acces.IThermopileDecay;
import com.cout970.magneticraft.api.acces.RecipeBiomassBurner;
import com.cout970.magneticraft.api.acces.RecipeCrusher;
import com.cout970.magneticraft.api.acces.RecipeGrinder;
import com.cout970.magneticraft.api.acces.RecipeOilDistillery;
import com.cout970.magneticraft.api.acces.RecipeRefinery;
import com.cout970.magneticraft.api.acces.RecipeSifter;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.ThermopileFuel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class MgRecipeRegister {
    public static List<RecipeCrusher> crusher = new ArrayList<RecipeCrusher>();
    public static List<RecipeGrinder> grinder = new ArrayList<RecipeGrinder>();
    public static List<RecipeSifter> sifter = new ArrayList<RecipeSifter>();
    public static List<ThermopileFuel> thermopileSources = new ArrayList<ThermopileFuel>();
    public static List<IThermopileDecay> thermopileDecais = new ArrayList<IThermopileDecay>();
    public static List<RecipeBiomassBurner> biomassBurner = new ArrayList<RecipeBiomassBurner>();
    public static List<RecipeRefinery> refinery = new ArrayList<RecipeRefinery>();
    public static List<RecipeOilDistillery> oilDistillery = new ArrayList<RecipeOilDistillery>();

    public static boolean registerCrusherRecipe(ItemStack in, ItemStack out0, ItemStack out1, float prob1, ItemStack out2, float prob2) {
        if (in == null || out0 == null) {
            return false;
        }
        RecipeCrusher a = new RecipeCrusher(in, out0, out1, prob1, out2, prob2);
        if (!crusher.contains(a)) {
            crusher.add(a);
            return true;
        }
        return false;
    }

    public static boolean registerGrinderRecipe(ItemStack in, ItemStack out0, ItemStack out1, float prob1, ItemStack out2, float prob2) {
        if (in == null || out0 == null) {
            return false;
        }
        RecipeGrinder a = new RecipeGrinder(in, out0, out1, prob1, out2, prob2);
        if (!grinder.contains(a)) {
            grinder.add(a);
            return true;
        }
        return false;
    }

    public static boolean registerRefineryRecipe(FluidStack in, FluidStack a, FluidStack b, FluidStack c) {
        if (in == null) {
            return false;
        }
        RecipeRefinery recipe = new RecipeRefinery(in, a, b, c);
        if (!refinery.contains(recipe)) {
            refinery.add(recipe);
            return true;
        }
        return false;
    }

    public static boolean registerOilDistilleryRecipe(FluidStack in, FluidStack out, double cost) {
        if (in == null || out == null) {
            return false;
        }
        RecipeOilDistillery recipe = new RecipeOilDistillery(in, out, cost);
        if (!oilDistillery.contains(recipe)) {
            oilDistillery.add(recipe);
            return true;
        }
        return false;
    }

    public static boolean addBiomassBurnerRecipe(ItemStack item, int burnTime, boolean ignoreNBT) {
        if (item == null && burnTime <= 0) {
            return false;
        }
        RecipeBiomassBurner r = new RecipeBiomassBurner(item, burnTime, !ignoreNBT);
        if (!biomassBurner.contains(r)) {
            biomassBurner.add(r);
            return true;
        }
        return false;
    }

    public static boolean addThermopileSource(BlockInfo b, double temp, boolean heat) {
        if (b == null || temp == 0.0) {
            return false;
        }
        if (temp < 0.0) {
            return false;
        }
        ThermopileFuel f = new ThermopileFuel(b, temp, heat);
        if (!thermopileSources.contains(f)) {
            thermopileSources.add(f);
        }
        return true;
    }

    public static boolean addThermopileDecay(IThermopileDecay t) {
        if (t == null || thermopileDecais.contains(t)) {
            return false;
        }
        thermopileDecais.add(t);
        return true;
    }

    public static boolean registerSifterRecipe(ItemStack in, ItemStack out, ItemStack extra, float prob) {
        if (in == null || out == null) {
            return false;
        }
        RecipeSifter a = new RecipeSifter(in, out, extra, prob);
        if (!sifter.contains(a)) {
            sifter.add(a);
            return true;
        }
        return false;
    }
}

