/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.computer.impl;

import com.cout970.magneticraft.api.computer.IModuleCPU;
import com.cout970.magneticraft.api.computer.IModuleMemoryController;
import com.cout970.magneticraft.api.computer.impl.ComputerUtils;
import net.minecraft.nbt.NBTTagCompound;

public class ModuleCPU_MIPS
implements IModuleCPU {
    public IModuleMemoryController memory;
    public int[] registes = new int[32];
    public int HI = 0;
    public int LO = 0;
    public int regPC = 0;
    public int regStatus = 0;
    public int regCause = 0;
    public int regEPC = 0;
    public int cpuCicles = -1;

    @Override
    public void connectMemory(IModuleMemoryController ram) {
        this.memory = ram;
    }

    @Override
    public boolean isRunning() {
        return this.cpuCicles >= 0;
    }

    @Override
    public void start() {
        this.cpuCicles = 0;
        this.memory.clear();
        this.regPC = 0x400000;
        this.regStatus = 65535;
        this.regCause = 0;
        this.regEPC = 0;
        for (int i = 0; i < 32; ++i) {
            this.setRegister(i, 0);
        }
    }

    @Override
    public void stop() {
        this.cpuCicles = -1;
    }

    @Override
    public void iterate() {
        if (this.cpuCicles >= 0) {
            this.cpuCicles += 2000;
            if (this.cpuCicles > 100000) {
                this.cpuCicles = 100000;
            }
            while (this.cpuCicles > 0) {
                --this.cpuCicles;
                this.executeInsntruction();
            }
        }
    }

    public void advancePC() {
        this.regPC += 4;
    }

    @Override
    public void setRegister(int s, int val) {
        if (s == 0) {
            return;
        }
        this.registes[s] = val;
    }

    @Override
    public int getRegister(int t) {
        return this.registes[t];
    }

    private void executeInsntruction() {
        int instruct = this.memory.readWord(this.regPC);
        this.advancePC();
        switch (this.CONTROL(instruct)) {
            case R: {
                this.TipeR(instruct);
                break;
            }
            case J: {
                this.TipeJ(instruct);
                break;
            }
            case I: {
                this.TipeI(instruct);
                break;
            }
            case Exeption: {
                this.Exception(instruct);
            }
        }
    }

    public IntructionType CONTROL(int instruct) {
        if (instruct == 0) {
            return IntructionType.NOP;
        }
        int opcode = ComputerUtils.getBitsFromInt(instruct, 26, 31, false);
        if (instruct == 12 || opcode == 16) {
            return IntructionType.Exeption;
        }
        if (opcode == 0) {
            return IntructionType.R;
        }
        if (opcode == 2 || opcode == 3) {
            return IntructionType.J;
        }
        return IntructionType.I;
    }

    public void TipeR(int instruct) {
        int func = ComputerUtils.getBitsFromInt(instruct, 0, 5, false);
        int shamt = ComputerUtils.getBitsFromInt(instruct, 6, 10, false);
        int rd = ComputerUtils.getBitsFromInt(instruct, 11, 15, false);
        int rt = ComputerUtils.getBitsFromInt(instruct, 16, 20, false);
        int rs = ComputerUtils.getBitsFromInt(instruct, 21, 25, false);
        switch (func) {
            case 0: {
                this.setRegister(rd, rt << shamt);
                break;
            }
            case 2: {
                this.setRegister(rd, rt >>> shamt);
                break;
            }
            case 3: {
                this.setRegister(rd, rt >> shamt);
                break;
            }
            case 4: {
                this.setRegister(rd, rt << rs);
                break;
            }
            case 6: {
                this.setRegister(rd, rt >> rs);
                break;
            }
            case 7: {
                this.setRegister(rd, rs >>> rt);
                break;
            }
            case 8: {
                if (this.getRegister(rs) == 0 || this.getRegister(rs) == -1) {
                    this.throwException(4);
                    return;
                }
                this.regPC = this.getRegister(rs);
                break;
            }
            case 9: {
                if (this.getRegister(rs) == -1 || this.getRegister(rs) == 0) {
                    this.throwException(4);
                }
                this.setRegister(31, this.regPC);
                this.regPC = this.getRegister(rs);
                break;
            }
            case 16: {
                this.setRegister(rd, this.HI);
                break;
            }
            case 17: {
                this.HI = this.getRegister(rd);
                break;
            }
            case 18: {
                this.setRegister(rd, this.LO);
                break;
            }
            case 19: {
                this.LO = this.getRegister(rd);
                break;
            }
            case 24: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                long mt = m1 * m2;
                this.LO = (int)mt;
                this.HI = (int)(mt >> 32);
                break;
            }
            case 25: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                m1 = m1 << 32 >>> 32;
                m2 = m2 << 32 >>> 32;
                long mt = m1 * m2;
                this.LO = (int)mt;
                this.HI = (int)(mt >> 32);
                break;
            }
            case 26: {
                if (this.getRegister(rt) != 0) {
                    this.LO = this.getRegister(rs) / this.getRegister(rt);
                    this.HI = this.getRegister(rs) % this.getRegister(rt);
                    break;
                }
                this.throwException(2);
                break;
            }
            case 27: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                m1 = m1 << 32 >>> 32;
                m2 = m2 << 32 >>> 32;
                if (m2 == 0L) {
                    this.throwException(2);
                    break;
                }
                this.LO = (int)(m1 / m2);
                this.HI = (int)(m1 % m2);
                break;
            }
            case 32: {
                this.setRegister(rd, this.getRegister(rt) + this.getRegister(rs));
                break;
            }
            case 33: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                m1 = m1 << 32 >>> 32;
                m2 = m2 << 32 >>> 32;
                long mt = m1 + m2;
                this.setRegister(rd, (int)mt);
                break;
            }
            case 34: {
                this.setRegister(rd, this.getRegister(rs) - this.getRegister(rt));
                break;
            }
            case 35: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                long mt = (m1 &= 0xFFFFFFFFFFFFFFFFL) - (m2 &= 0xFFFFFFFFFFFFFFFFL);
                this.setRegister(rd, (int)(mt &= 0xFFFFFFFFFFFFFFFFL));
                break;
            }
            case 36: {
                this.setRegister(rd, this.getRegister(rt) & this.getRegister(rs));
                break;
            }
            case 37: {
                this.setRegister(rd, this.getRegister(rt) | this.getRegister(rs));
                break;
            }
            case 38: {
                this.setRegister(rd, this.getRegister(rt) ^ this.getRegister(rs));
                break;
            }
            case 39: {
                this.setRegister(rd, ~(this.getRegister(rt) | this.getRegister(rs)));
                break;
            }
            case 42: {
                if (this.getRegister(rs) < this.getRegister(rt)) {
                    this.setRegister(rd, 1);
                    break;
                }
                this.setRegister(rd, 0);
                break;
            }
            case 43: {
                long m1 = this.getRegister(rs);
                long m2 = this.getRegister(rt);
                m1 = m1 << 32 >>> 32;
                m2 = m2 << 32 >>> 32;
                if (m1 < m2) {
                    this.setRegister(rd, 1);
                    break;
                }
                this.setRegister(rd, 0);
                break;
            }
            default: {
                this.throwException(1);
            }
        }
    }

    public void TipeJ(int instruct) {
        int dir = ComputerUtils.getBitsFromInt(instruct, 0, 25, false);
        int code = ComputerUtils.getBitsFromInt(instruct, 26, 31, false);
        switch (code) {
            case 2: {
                this.regPC &= 0xF0000000;
                this.regPC |= dir << 2;
                break;
            }
            case 3: {
                this.setRegister(31, this.regPC);
                this.regPC &= 0xF0000000;
                this.regPC |= dir << 2;
                break;
            }
            default: {
                this.throwException(1);
            }
        }
    }

    private void TipeI(int instruct) {
        long m1 = 0L;
        long m2 = 0L;
        int opcode = ComputerUtils.getBitsFromInt(instruct, 26, 31, false);
        int rs = ComputerUtils.getBitsFromInt(instruct, 21, 25, false);
        int rt = ComputerUtils.getBitsFromInt(instruct, 16, 20, false);
        int inmed = ComputerUtils.getBitsFromInt(instruct, 0, 15, true);
        int inmedU = ComputerUtils.getBitsFromInt(instruct, 0, 15, false);
        switch (opcode) {
            case 1: {
                if (rt == 1) {
                    if (this.getRegister(rs) < 0) break;
                    this.regPC += inmed << 2;
                    break;
                }
                if (rt != 0 || this.getRegister(rs) >= 0) break;
                this.regPC += inmed << 2;
                break;
            }
            case 4: {
                if (this.getRegister(rt) != this.getRegister(rs)) break;
                this.regPC += inmed << 2;
                break;
            }
            case 5: {
                if (this.getRegister(rt) == this.getRegister(rs)) break;
                this.regPC += inmed << 2;
                break;
            }
            case 6: {
                if (this.getRegister(rs) > 0) break;
                this.regPC += inmed << 2;
                break;
            }
            case 7: {
                if (this.getRegister(rs) <= 0) break;
                this.regPC += inmed << 2;
                break;
            }
            case 8: {
                this.setRegister(rt, this.getRegister(rs) + inmed);
                break;
            }
            case 9: {
                this.setRegister(rt, this.getRegister(rs) + inmed);
                break;
            }
            case 10: {
                if (this.getRegister(rs) < inmed) {
                    this.setRegister(rt, 1);
                    break;
                }
                this.setRegister(rt, 0);
                break;
            }
            case 11: {
                m1 = this.getRegister(rs);
                m2 = inmed;
                m1 = m1 << 32 >>> 32;
                m2 = m2 << 32 >>> 32;
                if (m1 < m2) {
                    this.setRegister(rt, 1);
                    break;
                }
                this.setRegister(rt, 0);
                break;
            }
            case 12: {
                this.setRegister(rt, this.getRegister(rs) & inmedU);
                break;
            }
            case 13: {
                this.setRegister(rt, this.getRegister(rs) | inmedU);
                break;
            }
            case 14: {
                this.setRegister(rt, this.getRegister(rs) ^ inmedU);
                break;
            }
            case 15: {
                this.setRegister(rt, inmedU << 16);
                break;
            }
            case 24: {
                this.setRegister(rt, this.getRegister(rt) & 0xFFFF0000 | inmedU);
                break;
            }
            case 25: {
                this.setRegister(rt, this.getRegister(rt) & 0xFFFF | inmedU << 16);
                break;
            }
            case 26: {
                break;
            }
            case 32: {
                this.setRegister(rt, this.memory.readByte(this.getRegister(rs) + inmed));
                break;
            }
            case 33: {
                this.setRegister(rt, (short)this.memory.readWord(this.getRegister(rs) + inmed));
                break;
            }
            case 35: {
                if ((this.getRegister(rs) + inmed & 3) != 0) {
                    this.throwException(5);
                    break;
                }
                this.setRegister(rt, this.memory.readWord(this.getRegister(rs) + inmed));
                break;
            }
            case 36: {
                this.setRegister(rt, this.memory.readByte(this.getRegister(rs) + inmed) & 0xFF);
                break;
            }
            case 37: {
                this.setRegister(rt, this.memory.readWord(this.getRegister(rs) + inmed) & 0xFFFF);
                break;
            }
            case 40: {
                this.memory.writeByte(this.getRegister(rs) + inmed, (byte)(this.getRegister(rt) & 0xFF));
                break;
            }
            case 41: {
                this.memory.writeByte(this.getRegister(rs) + inmed, (byte)(this.getRegister(rt) & 0xFF));
                this.memory.writeByte(this.getRegister(rs) + inmed + 1, (byte)(this.getRegister(rt) & 0xFF00));
                break;
            }
            case 43: {
                if ((this.getRegister(rs) + inmed & 3) != 0) {
                    this.throwException(5);
                    break;
                }
                this.memory.writeWord(this.getRegister(rs) + inmed, this.getRegister(rt));
                break;
            }
            default: {
                this.throwException(1);
            }
        }
    }

    public void Exception(int instruct) {
        if (instruct == 1107296272) {
            this.regPC = this.regEPC;
            this.regStatus >>= 4;
            return;
        }
        if (instruct == 12) {
            this.throwException(3);
            return;
        }
        int code = ComputerUtils.getBitsFromInt(instruct, 21, 25, false);
        int rt = ComputerUtils.getBitsFromInt(instruct, 16, 20, false);
        int rd = ComputerUtils.getBitsFromInt(instruct, 11, 15, false);
        if (code == 0) {
            int val = 0;
            if (rt == 12) {
                val = this.regStatus;
            }
            if (rt == 13) {
                val = this.regCause;
            }
            if (rt == 14) {
                val = this.regEPC;
            }
            this.setRegister(rd, val);
            return;
        }
        if (code == 4) {
            int val = this.getRegister(rt);
            if (rt == 12) {
                this.regStatus = val;
            }
            if (rt == 13) {
                this.regCause = val;
            }
            if (rt == 14) {
                this.regEPC = val;
            }
            return;
        }
        this.throwException(1);
    }

    public void throwException(int flag) {
        this.stop();
    }

    @Override
    public void loadRegisters(NBTTagCompound nbt) {
        this.registes = nbt.func_74759_k("Regs");
        if (this.registes.length != 32) {
            this.registes = new int[32];
        }
        this.cpuCicles = nbt.func_74762_e("Cicles");
        this.regPC = nbt.func_74762_e("PC");
        this.HI = nbt.func_74762_e("HI");
        this.LO = nbt.func_74762_e("LO");
        this.regStatus = nbt.func_74762_e("Status");
        this.regCause = nbt.func_74762_e("Cause");
        this.regEPC = nbt.func_74762_e("EPC");
    }

    @Override
    public void saveRegisters(NBTTagCompound nbt) {
        nbt.func_74783_a("Regs", this.registes);
        nbt.func_74768_a("Cicles", this.cpuCicles);
        nbt.func_74768_a("PC", this.regPC);
        nbt.func_74768_a("HI", this.HI);
        nbt.func_74768_a("LO", this.LO);
        nbt.func_74768_a("Status", this.regStatus);
        nbt.func_74768_a("Cause", this.regCause);
        nbt.func_74768_a("EPC", this.regEPC);
    }

    @Override
    public int getRegPC() {
        return this.regPC;
    }

    @Override
    public void setRegPC(int value) {
        this.regPC = value;
    }

    public static enum IntructionType {
        R,
        I,
        J,
        Exeption,
        NOP;

    }
}

