/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.computer.impl;

import com.cout970.magneticraft.api.computer.IModuleDiskDrive;
import com.cout970.magneticraft.api.computer.IPeripheral;
import com.cout970.magneticraft.api.computer.IStorageDevice;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ModuleDisckDrive
implements IModuleDiskDrive,
IPeripheral {
    protected ItemStack disk;
    protected byte[] diskBuffer;
    protected int sector;
    protected int regAction = -1;
    protected int address = 2;
    protected int accessTime = 0;
    protected TileEntity tile;

    public ModuleDisckDrive(TileEntity t) {
        this.tile = t;
    }

    @Override
    public byte[] getRawBuffer() {
        if (this.diskBuffer == null) {
            this.diskBuffer = new byte[128];
        }
        if (this.diskBuffer.length != 128) {
            this.diskBuffer = new byte[128];
        }
        return this.diskBuffer;
    }

    @Override
    public int getSector() {
        return this.sector;
    }

    @Override
    public void setSector(int sector) {
        this.sector = sector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readToBuffer() {
        ItemStack item = this.getDisk();
        if (item != null) {
            IStorageDevice storage = (IStorageDevice)item.func_77973_b();
            if (storage.getSize(item) >= this.getSector()) {
                return;
            }
            File f = storage.getAsociateFile(item);
            if (f == null) {
                return;
            }
            RandomAccessFile acces = null;
            try {
                acces = new RandomAccessFile(f, "r");
                acces.seek(this.getSector() * 128);
                this.regAction = acces.read(this.diskBuffer) == 128 ? 0 : -1;
            }
            catch (IOException e) {
                this.regAction = -1;
                e.printStackTrace();
            }
            finally {
                try {
                    if (acces != null) {
                        acces.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToFile() {
        ItemStack item = this.getDisk();
        if (item != null) {
            IStorageDevice storage = (IStorageDevice)item.func_77973_b();
            if (storage.getSize(item) >= this.getSector()) {
                return;
            }
            File f = storage.getAsociateFile(item);
            if (f == null) {
                return;
            }
            RandomAccessFile acces = null;
            try {
                acces = new RandomAccessFile(f, "rw");
                acces.seek(this.getSector() * 128);
                acces.write(this.diskBuffer);
                this.regAction = 0;
            }
            catch (IOException e) {
                this.regAction = -1;
                e.printStackTrace();
            }
            finally {
                try {
                    if (acces != null) {
                        acces.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public ItemStack getDisk() {
        ItemStack i = this.disk;
        if (i != null && i.func_77973_b() != null && i.func_77973_b() instanceof IStorageDevice && ((IStorageDevice)i.func_77973_b()).isFloppyDrive(i)) {
            return i;
        }
        return null;
    }

    @Override
    public boolean insertDisk(ItemStack i) {
        if (i == null) {
            this.disk = null;
            return true;
        }
        if (i.func_77973_b() != null && i.func_77973_b() instanceof IStorageDevice && ((IStorageDevice)i.func_77973_b()).isFloppyDrive(i) && this.disk == null) {
            this.disk = i;
            return true;
        }
        return false;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.diskBuffer = nbt.func_74770_j("Disk_Drive_Buffer");
        this.sector = nbt.func_74762_e("Disk_Drive_Sector");
        this.address = nbt.func_74762_e("Disk_Drive_Address");
        this.regAction = nbt.func_74762_e("Disk_Drive_Action");
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74773_a("Disk_Drive_Buffer", this.getRawBuffer());
        nbt.func_74768_a("Disk_Drive_Sector", this.sector);
        nbt.func_74768_a("Disk_Drive_Address", this.address);
        nbt.func_74768_a("Disk_Drive_Action", this.regAction);
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(int address) {
        this.address = address;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public int readByte(int pointer) {
        if (pointer < 0) {
            return 0;
        }
        if (pointer < 128) {
            return this.diskBuffer[pointer];
        }
        if (pointer == 128) {
            return this.sector & 0xFF;
        }
        if (pointer == 129) {
            return this.sector >> 8;
        }
        if (pointer == 130) {
            return this.regAction;
        }
        return 0;
    }

    @Override
    public void writeByte(int pointer, int data) {
        if (pointer < 0) {
            return;
        }
        if (pointer < 128) {
            this.diskBuffer[pointer] = (byte)data;
        }
        if (pointer == 128) {
            this.sector = this.sector & 0xFF00 | data & 0xFF;
        }
        if (pointer == 129) {
            this.sector |= this.sector & 0xFF | data << 8;
        }
        if (pointer == 130) {
            this.regAction = data;
        }
    }

    @Override
    public void iterate() {
        if (this.accessTime <= 0) {
            if (this.regAction != -1 && this.getDisk() != null) {
                IStorageDevice drive = (IStorageDevice)this.getDisk().func_77973_b();
                if (this.regAction != 0) {
                    this.accessTime = drive.getAccessTime(this.getDisk());
                } else {
                    this.regAction = -1;
                }
                if (this.regAction == 1) {
                    Arrays.fill(this.diskBuffer, (byte)0);
                    try {
                        byte[] label = drive.getDiskLabel(this.getDisk()).getBytes("US-ASCII");
                        System.arraycopy(label, 0, this.diskBuffer, 0, Math.min(label.length, 128));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.regAction = 0;
                } else if (this.regAction == 2) {
                    int length;
                    for (length = 0; this.diskBuffer[length] != 0 && length < 64; ++length) {
                    }
                    try {
                        String label = new String(this.diskBuffer, 0, length, "US-ASCII");
                        drive.setDiskLabel(this.getDisk(), label);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.regAction = 0;
                } else if (this.regAction == 3) {
                    Arrays.fill(this.diskBuffer, (byte)0);
                    drive.getAsociateFile(this.getDisk());
                    try {
                        byte[] serial = drive.getSerialNumber(this.getDisk()).getBytes("US-ASCII");
                        System.arraycopy(serial, 0, this.diskBuffer, 0, Math.min(serial.length, 128));
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    this.regAction = 0;
                } else if (this.regAction == 4) {
                    if (this.sector > drive.getSize(this.getDisk())) {
                        this.regAction = -1;
                        return;
                    }
                    this.readToBuffer();
                } else if (this.regAction == 5) {
                    if (this.sector > drive.getSize(this.getDisk())) {
                        this.regAction = -1;
                        return;
                    }
                    this.writeToFile();
                } else {
                    this.regAction = -1;
                }
            }
        } else {
            --this.accessTime;
        }
    }

    @Override
    public String getName() {
        return "DiskDrive";
    }

    @Override
    public TileEntity getParent() {
        return this.tile;
    }
}

