/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.computer.impl;

import com.cout970.magneticraft.api.computer.IComputer;
import com.cout970.magneticraft.api.computer.IModuleMemoryController;
import com.cout970.magneticraft.api.computer.IPeripheral;
import com.cout970.magneticraft.api.computer.impl.ComputerUtils;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;

public class ModuleMemoryController
implements IModuleMemoryController {
    private byte[][] memory;
    private boolean littleEndian;
    private int size;
    private int modules;
    private IComputer compu;
    private IPeripheral cache;

    public ModuleMemoryController(int size, boolean little, int modules) {
        this.modules = modules;
        this.memory = new byte[modules][];
        for (int i = 0; i < modules; ++i) {
            this.memory[i] = new byte[size / modules];
        }
        this.size = size;
        this.littleEndian = little;
    }

    @Override
    public int readWord(int pos) {
        int dato;
        if (this.littleEndian) {
            dato = this.readByte(pos + 3) & 0xFF;
            dato |= (this.readByte(pos + 2) & 0xFF) << 8;
            dato |= (this.readByte(pos + 1) & 0xFF) << 16;
            dato |= (this.readByte(pos) & 0xFF) << 24;
        } else {
            dato = this.readByte(pos) & 0xFF;
            dato |= (this.readByte(pos + 1) & 0xFF) << 8;
            dato |= (this.readByte(pos + 2) & 0xFF) << 16;
            dato |= (this.readByte(pos + 3) & 0xFF) << 24;
        }
        return dato;
    }

    @Override
    public byte readByte(int pos) {
        if ((pos & 0xFF000000) == -16777216) {
            if (this.getComputer() == null) {
                return 0;
            }
            int addr = (pos & 0xFF0000) >> 16;
            if (this.cache == null || this.cache.getAddress() != addr) {
                this.cache = ComputerUtils.getBusByAddress(this.getComputer().getParent(), addr);
            }
            if (this.cache == null) {
                return 0;
            }
            return (byte)this.cache.readByte(pos & 0xFFFF);
        }
        if ((pos = ModuleMemoryController.getRealAddress(this, pos)) < 0 || pos >= this.getMemorySize()) {
            return 0;
        }
        return this.memory[pos / this.memory[0].length][pos % this.memory[0].length];
    }

    @Override
    public void writeByte(int pos, byte dato) {
        if ((pos & 0xFF000000) == -16777216) {
            if (this.getComputer() == null) {
                return;
            }
            int addr = (pos & 0xFF0000) >> 16;
            if (this.cache == null || this.cache.getAddress() != addr || this.cache.getParent().func_145837_r()) {
                this.cache = ComputerUtils.getBusByAddress(this.getComputer().getParent(), addr);
            }
            if (this.cache == null) {
                return;
            }
            this.cache.writeByte(pos & 0xFFFF, dato);
            return;
        }
        if ((pos = ModuleMemoryController.getRealAddress(this, pos)) < 0 || pos >= this.getMemorySize()) {
            return;
        }
        this.memory[pos / this.memory[0].length][pos % this.memory[0].length] = dato;
    }

    @Override
    public void writeWord(int pos, int dato) {
        if (this.littleEndian) {
            this.writeByte(pos + 3, (byte)(dato & 0xFF));
            this.writeByte(pos + 2, (byte)((dato & 0xFF00) >> 8));
            this.writeByte(pos + 1, (byte)((dato & 0xFF0000) >> 16));
            this.writeByte(pos, (byte)((dato & 0xFF000000) >> 24));
        } else {
            this.writeByte(pos, (byte)(dato & 0xFF));
            this.writeByte(pos + 1, (byte)((dato & 0xFF00) >> 8));
            this.writeByte(pos + 2, (byte)((dato & 0xFF0000) >> 16));
            this.writeByte(pos + 3, (byte)((dato & 0xFF000000) >> 24));
        }
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public void setLittelEndian(boolean little) {
        this.littleEndian = little;
    }

    @Override
    public int getMemorySize() {
        return this.size;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.modules; ++i) {
            Arrays.fill(this.memory[i], (byte)0);
        }
    }

    @Override
    public void loadMemory(NBTTagCompound nbt) {
        this.modules = nbt.func_74762_e("Modules_RAM");
        this.size = nbt.func_74762_e("Size");
        this.memory = new byte[this.modules][];
        for (int i = 0; i < this.modules; ++i) {
            this.memory[i] = nbt.func_74770_j("Module_RAM_" + i);
            if (this.memory[i].length == this.size) continue;
            this.memory[i] = new byte[this.size];
        }
    }

    @Override
    public void saveMemory(NBTTagCompound nbt) {
        nbt.func_74768_a("Modules_RAM", this.modules);
        nbt.func_74768_a("Size", this.size);
        for (int i = 0; i < this.modules; ++i) {
            nbt.func_74773_a("Module_RAM_" + i, this.memory[i]);
        }
    }

    public static int getRealAddress(IModuleMemoryController ram, int address) {
        int mask = ComputerUtils.getBitsFromInt(address, 16, 31, false);
        if (mask == 64) {
            return address - 0x400000 & 0xFFFF;
        }
        if (mask == 4097) {
            return address - 0x10010000 + 12288 & 0xFFFF;
        }
        return address & 0xFFFF;
    }

    @Override
    public IComputer getComputer() {
        return this.compu;
    }

    @Override
    public void setComputer(IComputer c) {
        this.compu = c;
    }
}

