/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.computer.impl;

import com.cout970.magneticraft.api.computer.IPeripheral;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class MonitorPeripheral
implements IPeripheral {
    public static final int KEYBOARD_MASK = -16711680;
    public static final int TEXT_MASK = -16711660;
    private byte[] buffer;
    private int regReady;
    private int regChar;
    private int address = 1;
    private TileEntity parent;

    public MonitorPeripheral(TileEntity tile) {
        this.parent = tile;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    @Override
    public void setAddress(int address) {
        this.address = address;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public String getName() {
        return "TextMonitor";
    }

    @Override
    public int readByte(int pointer) {
        if (pointer >= this.getBuffer().length) {
            return 0;
        }
        return this.getBuffer()[pointer];
    }

    @Override
    public void writeByte(int pointer, int data) {
        if (pointer >= this.getBuffer().length) {
            return;
        }
        this.getBuffer()[pointer] = (byte)data;
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }

    public byte[] getBuffer() {
        if (this.buffer == null || this.buffer.length != 4020) {
            this.buffer = new byte[4020];
        }
        return this.buffer;
    }

    public int getText(int pos) {
        return this.getBuffer()[pos + 20];
    }

    public void keyPresed(int key) {
        this.regReady |= 1;
        this.regChar = key;
    }

    public void load(NBTTagCompound main) {
        NBTTagList list = main.func_150295_c("TextMonitor", 10);
        NBTTagCompound nbt = list.func_150305_b(0);
        this.address = nbt.func_74762_e("Address");
        this.buffer = nbt.func_74770_j("Buffer");
        this.getBuffer();
    }

    public void save(NBTTagCompound main) {
        NBTTagList list = new NBTTagList();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("Address", this.address);
        nbt.func_74773_a("Buffer", this.getBuffer());
        list.func_74742_a((NBTBase)nbt);
        main.func_74782_a("TextMonitor", (NBTBase)list);
    }

    public void saveInfoToMessage(NBTTagCompound nbt) {
        nbt.func_74774_a("Ready", (byte)this.regReady);
        nbt.func_74774_a("Char", (byte)this.regChar);
    }

    public void loadInfoFromMessage(NBTTagCompound nbt) {
        this.getBuffer()[0] = nbt.func_74771_c("Ready");
        this.getBuffer()[4] = nbt.func_74771_c("Char");
    }
}

