/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.conveyor;

import com.cout970.magneticraft.api.conveyor.IConveyor;
import com.cout970.magneticraft.api.conveyor.ItemBox;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.util.MgBeltUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class ConveyorSide {
    public IConveyor parent;
    public List<ItemBox> content = new ArrayList<ItemBox>();
    public boolean[] spaces = new boolean[16];
    public boolean isLeft;

    public ConveyorSide(IConveyor parent, boolean isLeft) {
        this.parent = parent;
        this.isLeft = isLeft;
    }

    public void addvance(ItemBox b) {
        this.setSpace(b.getPosition(), false);
        if (this.hasSpace(b.getPosition() + 1)) {
            b.setPosition(b.getPosition() + 1);
        }
        this.setSpace(b.getPosition(), true);
    }

    public void setSpace(int pos, boolean value) {
        TileEntity tile = null;
        if (4 + pos >= this.spaces.length) {
            tile = ConveyorSide.getFrontConveyor(this.parent);
        }
        for (int i = 0; i < 4; ++i) {
            if (i + pos >= this.spaces.length) {
                this.setSpaceExtern(tile, i + pos - 16, value);
                continue;
            }
            this.spaces[pos + i] = value;
        }
    }

    public void setSpaceExtern(TileEntity tile, int pos, boolean value) {
        block8: {
            IConveyor.BeltInteraction iter;
            block10: {
                block9: {
                    if (!MgBeltUtils.isBelt(tile)) break block8;
                    IConveyor con = (IConveyor)tile;
                    iter = IConveyor.BeltInteraction.InterBelt(this.parent.getDir(), con.getDir());
                    if (iter != IConveyor.BeltInteraction.DIRECT) break block9;
                    con.getSideLane((boolean)this.isLeft).spaces[pos % 16] = value;
                    break block8;
                }
                if (iter != IConveyor.BeltInteraction.LEFT_T) break block10;
                if (this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        con.getSideLane((boolean)false).spaces[i % 16] = value;
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        con.getSideLane((boolean)false).spaces[i % 16] = value;
                    }
                }
                break block8;
            }
            if (iter != IConveyor.BeltInteraction.RIGHT_T) break block8;
            if (!this.isLeft) {
                for (int i = 2; i < 6; ++i) {
                    con.getSideLane((boolean)true).spaces[i % 16] = value;
                }
            } else {
                for (int i = 10; i < 14; ++i) {
                    con.getSideLane((boolean)true).spaces[i % 16] = value;
                }
            }
        }
    }

    public boolean hasSpace(int pos) {
        TileEntity tile = null;
        if (4 + pos >= this.spaces.length) {
            tile = ConveyorSide.getFrontConveyor(this.parent);
        }
        for (int i = 0; i < 4; ++i) {
            if (!(i + pos >= this.spaces.length ? !this.hasSpaceExtern(tile, i + pos - 16) : this.spaces[pos + i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasSpaceExtern(TileEntity tile, int pos) {
        if (MgBeltUtils.isBelt(tile)) {
            IConveyor con = (IConveyor)tile;
            boolean temp = false;
            IConveyor.BeltInteraction iter = IConveyor.BeltInteraction.InterBelt(this.parent.getDir(), con.getDir());
            if (iter == IConveyor.BeltInteraction.DIRECT) {
                return !con.getSideLane((boolean)this.isLeft).spaces[pos % 16];
            }
            if (iter == IConveyor.BeltInteraction.LEFT_T) {
                if (this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        temp |= con.getSideLane((boolean)false).spaces[i % 16];
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        temp |= con.getSideLane((boolean)false).spaces[i % 16];
                    }
                }
                return !temp;
            }
            if (iter == IConveyor.BeltInteraction.RIGHT_T) {
                if (!this.isLeft) {
                    for (int i = 2; i < 6; ++i) {
                        temp |= con.getSideLane((boolean)true).spaces[i % 16];
                    }
                } else {
                    for (int i = 10; i < 14; ++i) {
                        temp |= con.getSideLane((boolean)true).spaces[i % 16];
                    }
                }
                return !temp;
            }
        }
        return false;
    }

    public void save(NBTTagCompound nbt) {
        String side = this.isLeft ? "Left" : "Right";
        for (int i = 0; i < this.spaces.length; ++i) {
            nbt.func_74757_a(side + "_" + i, this.spaces[i]);
        }
        NBTTagList list = new NBTTagList();
        nbt.func_74768_a(side + "Size", this.content.size());
        for (int i = 0; i < this.content.size(); ++i) {
            NBTTagCompound t = new NBTTagCompound();
            if (this.content.get(i) != null) {
                this.content.get(i).save(t);
            }
            list.func_74742_a((NBTBase)t);
        }
        nbt.func_74782_a(side + "_Boxes", (NBTBase)list);
    }

    public void load(NBTTagCompound nbt) {
        String side = this.isLeft ? "Left" : "Right";
        this.content.clear();
        for (int i = 0; i < this.spaces.length; ++i) {
            this.spaces[i] = nbt.func_74767_n(side + "_" + i);
        }
        int content_size = nbt.func_74762_e(side + "Size");
        ItemBox box = null;
        NBTTagList list = nbt.func_150295_c(side + "_Boxes", 10);
        for (int i = 0; i < content_size; ++i) {
            NBTTagCompound t = list.func_150305_b(i);
            if (!t.func_74764_b("Left")) continue;
            box = new ItemBox(null);
            box.load(t);
            this.content.add(box);
        }
    }

    public static TileEntity getFrontConveyor(IConveyor c) {
        TileEntity t = c.getParent();
        if (c.getOrientation().getLevel() == 1) {
            return MgUtils.getTileEntity(t, c.getDir().toVecInt().add(0, 1, 0));
        }
        TileEntity retval = MgUtils.getTileEntity(t, c.getDir());
        if (!MgBeltUtils.isBelt(retval)) {
            retval = MgUtils.getTileEntity(t, c.getDir().toVecInt().add(0, -1, 0));
        }
        return retval;
    }
}

