/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity;

import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class BufferedConductor
extends ElectricConductor {
    public int storage;
    public int maxStorage;
    public double min;
    public double max;

    public BufferedConductor(TileEntity tile, double resist, int storage, double min, double max) {
        super(tile, resist);
        this.maxStorage = storage;
        this.min = min;
        this.max = max;
    }

    @Override
    public void iterate() {
        super.iterate();
        if (this.getVoltage() > this.max && this.storage < this.maxStorage) {
            int change = (int)Math.min((this.getVoltage() - this.max) * 80.0, EnergyConversor.RFtoW(100.0));
            change = Math.min(change, this.maxStorage - this.storage);
            this.drainPower(change);
            this.storage += change;
        } else if (this.getVoltage() < this.min && this.storage > 0) {
            int change = (int)Math.min((this.min - this.getVoltage()) * 80.0, EnergyConversor.RFtoW(100.0));
            change = Math.min(change, this.storage);
            this.applyPower(change);
            this.storage -= change;
        }
    }

    @Override
    public int getStorage() {
        return this.storage;
    }

    @Override
    public int getMaxStorage() {
        return this.maxStorage;
    }

    @Override
    public void setStorage(int charge) {
        this.storage = charge;
    }

    @Override
    public void applyCharge(int charge) {
        this.storage += charge;
        if (this.storage > this.maxStorage) {
            this.storage = this.maxStorage;
        }
    }

    @Override
    public void drainCharge(int charge) {
        this.storage -= charge;
        if (this.storage < 0) {
            this.storage = 0;
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74768_a("Storage", this.storage);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.storage = nbt.func_74762_e("Storage");
    }
}

