/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.compact;

import cofh.api.energy.IEnergyHandler;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.compact.EU_EnergyInterfaceSink;
import com.cout970.magneticraft.api.electricity.compact.RF_EnergyInterface;
import com.cout970.magneticraft.api.electricity.compact.RailcraftChargeEnergyInteface;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import ic2.api.energy.tile.IEnergySink;
import mods.railcraft.api.electricity.IElectricGrid;
import net.minecraft.tileentity.TileEntity;

public class InteractionHelper {
    public static IEnergyInterface processTile(TileEntity tile, VecInt f, int tier) {
        if (tier == 0) {
            if (tile instanceof IElectricGrid && ((IElectricGrid)tile).getChargeHandler().getType() == IElectricGrid.ChargeHandler.ConnectType.BLOCK) {
                return InteractionHelper.getElectricalGrid((IElectricGrid)tile);
            }
            if (tile instanceof IEnergyHandler && f.toMgDirection() != null && ((IEnergyHandler)tile).canConnectEnergy(f.toMgDirection().toForgeDir())) {
                return InteractionHelper.getEnergyHandler((IEnergyHandler)tile, f.toMgDirection());
            }
            if (tile instanceof IEnergySink && f.toMgDirection() != null && ((IEnergySink)tile).acceptsEnergyFrom(null, f.toMgDirection().toForgeDir())) {
                return InteractionHelper.getEnergySink((IEnergySink)tile, f.toMgDirection());
            }
        }
        return null;
    }

    public static IEnergyInterface getEnergySink(IEnergySink tile, MgDirection dir) {
        return new EU_EnergyInterfaceSink(tile, dir);
    }

    public static IEnergyInterface getElectricalGrid(IElectricGrid g) {
        return new RailcraftChargeEnergyInteface(g);
    }

    public static IEnergyInterface getEnergyHandler(IEnergyHandler tile, MgDirection dir) {
        return new RF_EnergyInterface(tile, dir);
    }
}

