/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.compact;

import cofh.api.energy.IEnergyHandler;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IndexedConnection;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import net.minecraft.tileentity.TileEntity;

public class RF_EnergyInterface
implements IEnergyInterface {
    private IEnergyHandler tile;
    private MgDirection dir;

    public RF_EnergyInterface(IEnergyHandler g, MgDirection dir) {
        this.tile = g;
        this.dir = dir;
    }

    @Override
    public double applyEnergy(double watts) {
        return EnergyConversor.RFtoW(this.tile.receiveEnergy(this.dir.toForgeDir(), (int)EnergyConversor.WtoRF(watts), false));
    }

    @Override
    public double getCapacity() {
        return EnergyConversor.RFtoW(this.tile.getMaxEnergyStored(this.dir.toForgeDir()));
    }

    @Override
    public double getEnergyStored() {
        return EnergyConversor.RFtoW(this.tile.getEnergyStored(this.dir.toForgeDir()));
    }

    @Override
    public double getMaxFlow() {
        return EnergyConversor.RFtoW(80.0);
    }

    @Override
    public TileEntity getParent() {
        return (TileEntity)this.tile;
    }

    @Override
    public boolean canConnect(VecInt f) {
        return this.tile.canConnectEnergy(this.dir.toForgeDir());
    }

    @Override
    public boolean canAcceptEnergy(IndexedConnection f) {
        return true;
    }
}

