/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.compact;

import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IndexedConnection;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.VecInt;
import mods.railcraft.api.electricity.IElectricGrid;
import net.minecraft.tileentity.TileEntity;

public class RailcraftChargeEnergyInteface
implements IEnergyInterface {
    public IElectricGrid.ChargeHandler c;
    public IElectricGrid grid;

    public RailcraftChargeEnergyInteface(IElectricGrid g) {
        this.c = g.getChargeHandler();
        this.grid = g;
    }

    @Override
    public double applyEnergy(double watts) {
        double energy = Math.min(this.c.getCapacity() - this.c.getCharge(), EnergyConversor.WtoRC(watts));
        this.c.addCharge(energy);
        return EnergyConversor.RCtoW(energy);
    }

    @Override
    public double getCapacity() {
        return EnergyConversor.RCtoW(this.c.getCapacity());
    }

    @Override
    public double getEnergyStored() {
        return EnergyConversor.RCtoW(this.c.getCharge());
    }

    @Override
    public double getMaxFlow() {
        return EnergyConversor.RCtoW(512.0);
    }

    @Override
    public TileEntity getParent() {
        return this.grid.getTile();
    }

    @Override
    public boolean canConnect(VecInt f) {
        return this.c.getType() == IElectricGrid.ChargeHandler.ConnectType.BLOCK;
    }

    @Override
    public boolean canAcceptEnergy(IndexedConnection f) {
        return true;
    }
}

