/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.wires;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.wires.IElectricPole;
import com.cout970.magneticraft.api.electricity.wires.WireConnection;
import com.cout970.magneticraft.api.electricity.wires.WireLoadInfo;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

public class ElectricPoleTier1
implements IElectricPole {
    protected List<WireConnection> connections = new ArrayList<WireConnection>();
    protected List<WireLoadInfo> buffer = new ArrayList<WireLoadInfo>();
    protected IElectricConductor cond;
    protected TileEntity parent;
    public int glList = -1;

    public ElectricPoleTier1(TileEntity tile, IElectricConductor cond) {
        this.parent = tile;
        this.cond = cond;
    }

    @Override
    public void disconectAll() {
        ArrayList<WireConnection> list = new ArrayList<WireConnection>();
        list.addAll(this.connections);
        for (WireConnection con : list) {
            if (con.getStart() != null) {
                con.getStart().onDisconnect(con);
            }
            if (con.getEnd() == null) continue;
            con.getEnd().onDisconnect(con);
        }
    }

    @Override
    public void iterate() {
        if (!this.buffer.isEmpty()) {
            this.connections.clear();
            for (int i = 0; i < this.buffer.size(); ++i) {
                WireLoadInfo info = this.buffer.get(i);
                WireConnection con = new WireConnection(info.start, info.end, this.parent.func_145831_w());
                this.connections.add(con);
            }
            this.refreshList();
            this.buffer.clear();
        }
        if (this.parent.func_145831_w().field_72995_K) {
            return;
        }
        for (WireConnection c : this.connections) {
            if (c.getStart() != this) continue;
            c.iterate();
        }
    }

    @Override
    public List<WireConnection> getConnectedConductors() {
        return this.connections;
    }

    @Override
    public boolean canConnectWire(int tier, IElectricPole to) {
        if (to == this) {
            return false;
        }
        if (tier != 0) {
            return false;
        }
        VecDouble vec = new VecDouble(this.getParent()).add(new VecDouble(to.getParent()).getOpposite());
        return !(vec.mag() > 16.0);
    }

    @Override
    public void onDisconnect(WireConnection conn) {
        this.connections.remove(conn);
        this.refreshList();
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }

    @Override
    public IElectricConductor getConductor() {
        return this.cond;
    }

    @Override
    public VecDouble[] getWireConnector() {
        switch (this.getParent().func_145832_p() - 6) {
            case 0: {
                return new VecDouble[]{new VecDouble(1.845, 0.75, 0.5), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.845, 0.75, 0.5)};
            }
            case 4: {
                return new VecDouble[]{new VecDouble(-0.845, 0.75, 0.5), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.845, 0.75, 0.5)};
            }
            case 1: {
                return new VecDouble[]{new VecDouble(1.45, 0.75, 1.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.45, 0.75, -0.45)};
            }
            case 5: {
                return new VecDouble[]{new VecDouble(-0.45, 0.75, -0.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.45, 0.75, 1.45)};
            }
            case 3: {
                return new VecDouble[]{new VecDouble(-0.45, 0.75, 1.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(1.45, 0.75, -0.45)};
            }
            case 7: {
                return new VecDouble[]{new VecDouble(1.45, 0.75, -0.45), new VecDouble(0.5, 1.0, 0.5), new VecDouble(-0.45, 0.75, 1.45)};
            }
            case 2: {
                return new VecDouble[]{new VecDouble(0.5, 0.75, 1.845), new VecDouble(0.5, 1.0, 0.5), new VecDouble(0.5, 0.75, -0.845)};
            }
            case 6: {
                return new VecDouble[]{new VecDouble(0.5, 0.75, -0.845), new VecDouble(0.5, 1.0, 0.5), new VecDouble(0.5, 0.75, 1.845)};
            }
        }
        return new VecDouble[0];
    }

    @Override
    public void onConnect(WireConnection wire) {
        this.connections.add(wire);
        this.refreshList();
    }

    private void refreshList() {
        if (this.getParent().func_145831_w().field_72995_K && this.glList != -1) {
            GL11.glDeleteLists((int)this.glList, (int)1);
            this.glList = -1;
        }
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList nbtList = new NBTTagList();
        for (WireConnection c : this.connections) {
            tag = new NBTTagCompound();
            c.save(tag);
            nbtList.func_74742_a((NBTBase)tag);
        }
        for (WireLoadInfo info : this.buffer) {
            tag = new NBTTagCompound();
            info.start.save(nbt, "Start");
            info.end.save(nbt, "End");
            nbt.func_74780_a("EnergyFlow", info.flow);
            nbtList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("connect", (NBTBase)nbtList);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        NBTTagList nbtList = nbt.func_150295_c("connect", 10);
        this.buffer.clear();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            WireLoadInfo wire = WireConnection.loadFromNBT(tag);
            if (wire == null) continue;
            this.buffer.add(wire);
        }
        if (this.buffer.isEmpty()) {
            this.disconectAll();
        }
    }

    public static void findConnections(IElectricPole pole) {
        pole.disconectAll();
        int rad = 16;
        for (int x = -rad; x <= rad; ++x) {
            for (int z = -rad; z <= rad; ++z) {
                for (int y = -5; y <= 5; ++y) {
                    TileEntity t;
                    IElectricPole p;
                    if (x == 0 && z == 0 || (p = MgUtils.getElectricPole(t = new VecInt(pole.getParent()).add(x, y, z).getTileEntity(pole.getParent().func_145831_w()))) == null || !p.canConnectWire(0, pole) || !pole.canConnectWire(0, p)) continue;
                    WireConnection wire = new WireConnection(new VecInt(pole.getParent()), new VecInt(p.getParent()), pole.getParent().func_145831_w());
                    pole.onConnect(wire);
                    p.onConnect(wire);
                }
            }
        }
    }
}

