/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.electricity.wires;

import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.wires.IElectricPole;
import com.cout970.magneticraft.api.electricity.wires.WireLoadInfo;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class WireConnection {
    private World w;
    private VecInt start;
    private VecInt end;
    private IElectricPole cache_start;
    private IElectricPole cache_end;
    private double distance;
    private double energyFlow;

    public WireConnection(VecInt s, VecInt e, World w) {
        this.start = s;
        this.end = e;
        VecDouble vec = new VecDouble(s).add(new VecDouble(e).getOpposite());
        this.distance = vec.mag();
        this.w = w;
    }

    public void iterate() {
        WireConnection.valanceConductors(this);
    }

    public double getEnergyFlow() {
        return this.energyFlow;
    }

    public void setEnergyFlow(double energyFlow) {
        this.energyFlow = energyFlow;
    }

    public IElectricPole getStart() {
        if (this.cache_start == null) {
            this.cache_start = MgUtils.getElectricPole(this.start.getTileEntity(this.w));
        }
        return this.cache_start;
    }

    public IElectricPole getEnd() {
        if (this.cache_end == null) {
            this.cache_end = MgUtils.getElectricPole(this.end.getTileEntity(this.w));
        }
        return this.cache_end;
    }

    public VecInt vecStart() {
        return this.start.copy();
    }

    public VecInt vecEnd() {
        return this.end.copy();
    }

    public double getDistance() {
        return this.distance;
    }

    public void save(NBTTagCompound nbt) {
        this.start.save(nbt, "Start");
        this.end.save(nbt, "End");
        nbt.func_74780_a("EnergyFlow", this.energyFlow);
    }

    public static WireLoadInfo loadFromNBT(NBTTagCompound nbt) {
        WireLoadInfo info = new WireLoadInfo();
        info.start = new VecInt(nbt, "Start");
        info.end = new VecInt(nbt, "End");
        info.flow = nbt.func_74769_h("EnergyFlow");
        return info;
    }

    public static WireConnection loadFromInfo(WireLoadInfo info, World w) {
        WireConnection wire = new WireConnection(info.start, info.end, w);
        wire.setEnergyFlow(info.flow);
        return wire;
    }

    public static void valanceConductors(WireConnection con) {
        if (con.getStart() == null || con.getEnd() == null) {
            return;
        }
        double resistence = con.distance * 0.01;
        IElectricConductor cond_start = con.getStart().getConductor();
        IElectricConductor cond_end = con.getEnd().getConductor();
        double deltaV = cond_start.getVoltage() - cond_end.getVoltage();
        if (Double.isNaN(con.energyFlow)) {
            con.energyFlow = 0.0;
        }
        double current = con.energyFlow;
        double vDiff = deltaV - current * resistence;
        vDiff = Math.min(vDiff, Math.abs(deltaV));
        vDiff = Math.max(vDiff, -Math.abs(deltaV));
        con.energyFlow += vDiff * cond_start.getIndScale() / cond_start.getVoltageMultiplier();
        cond_start.applyCurrent(-(current += deltaV * cond_start.getCondParallel() / cond_start.getVoltageMultiplier()));
        cond_end.applyCurrent(current);
    }
}

