/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.heat;

import com.cout970.magneticraft.api.heat.CompoundHeatCables;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class HeatConductor
implements IHeatConductor {
    public static final double SPECIFIC_HEAT = 0.2;
    private TileEntity parent;
    private double temperature = 25.0;
    private double mass;
    private double thermalResistance;
    private double maxHeat;

    public HeatConductor(TileEntity p, double max) {
        this(p, max, 1000.0, 0.5);
    }

    public HeatConductor(TileEntity p, double max, double mass) {
        this(p, max, mass, 0.5);
    }

    public HeatConductor(TileEntity p, double max, double mass, double res) {
        this.parent = p;
        this.maxHeat = max;
        this.mass = mass;
        this.thermalResistance = res;
    }

    @Override
    public double getMaxTemp() {
        return this.maxHeat;
    }

    @Override
    public double getTemperature() {
        if (Double.isNaN(this.temperature)) {
            this.temperature = 25.0;
        }
        if (this.temperature < -273.15) {
            this.temperature = -273.15;
        }
        return this.temperature;
    }

    @Override
    public TileEntity getParent() {
        return this.parent;
    }

    @Override
    public void iterate() {
        TileEntity t = this.getParent();
        World w = t.func_145831_w();
        if (w.field_72995_K) {
            return;
        }
        if (this.getTemperature() >= this.getMaxTemp()) {
            this.onBlockOverHeat();
        }
        for (MgDirection d : this.getValidConnections()) {
            CompoundHeatCables comp;
            TileEntity tile = MgUtils.getTileEntity(t, d);
            if (tile == null || (comp = MgUtils.getHeatCond(tile, d.toVecInt())) == null) continue;
            for (IHeatConductor h : comp.list()) {
                if (h == null || !h.isAbleToconnect(this, d.opposite().toVecInt()) || !this.isAbleToconnect(h, d.toVecInt())) continue;
                double diff = this.getTemperature() - h.getTemperature();
                double resistance = this.getResistance() + h.getResistance();
                double change = diff * 0.5 / resistance * EnergyConversor.FUELtoCALORIES(1.0);
                this.drainCalories(change);
                h.applyCalories(change);
            }
        }
    }

    @Override
    public double getResistance() {
        return this.thermalResistance;
    }

    @Override
    public void applyCalories(double j) {
        this.temperature += j / this.getMass() * 0.2;
    }

    @Override
    public void drainCalories(double j) {
        this.temperature -= j / this.getMass() * 0.2;
    }

    @Override
    public void save(NBTTagCompound nbt) {
        nbt.func_74780_a("Heat", this.temperature);
        nbt.func_74780_a("Mass", this.mass);
        nbt.func_74780_a("MaxHeat", this.maxHeat);
    }

    @Override
    public void load(NBTTagCompound nbt) {
        this.temperature = nbt.func_74769_h("Heat");
        this.mass = nbt.func_74769_h("Mass");
        this.maxHeat = nbt.func_74769_h("MaxHeat");
    }

    @Override
    public void setTemperature(double h) {
        this.temperature = h;
    }

    @Override
    public double getMass() {
        return this.mass;
    }

    @Override
    public void onBlockOverHeat() {
        TileEntity t = this.getParent();
        World w = t.func_145831_w();
        w.func_147449_b(t.field_145851_c, t.field_145848_d, t.field_145849_e, Blocks.field_150353_l);
        w.func_147460_e(t.field_145851_c, t.field_145848_d, t.field_145849_e, Blocks.field_150353_l);
    }

    @Override
    public MgDirection[] getValidConnections() {
        return MgDirection.values();
    }

    @Override
    public boolean isAbleToconnect(IHeatConductor cond, VecInt dir) {
        return true;
    }
}

