/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.api.computer.IOpticFiber;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.IElectricMultiPart;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IndexedConnection;
import com.cout970.magneticraft.api.electricity.compact.InteractionHelper;
import com.cout970.magneticraft.api.electricity.wires.IElectricPole;
import com.cout970.magneticraft.api.electricity.wires.ITileElectricPole;
import com.cout970.magneticraft.api.heat.CompoundHeatCables;
import com.cout970.magneticraft.api.heat.IHeatMultipart;
import com.cout970.magneticraft.api.heat.IHeatTile;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class MgUtils {
    public static boolean alreadyContains(IndexedConnection[] con, VecInt opp) {
        if (con == null) {
            return false;
        }
        if (opp == null) {
            return false;
        }
        for (IndexedConnection i : con) {
            if (opp != i.vecDir) continue;
            return true;
        }
        return false;
    }

    public static TileEntity getTileEntity(TileEntity tile, VecInt d) {
        if (tile == null) {
            return null;
        }
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + d.getX(), tile.field_145848_d + d.getY(), tile.field_145849_e + d.getZ());
    }

    public static TileEntity getTileEntity(TileEntity tile, MgDirection d) {
        return tile.func_145831_w().func_147438_o(tile.field_145851_c + d.getOffsetX(), tile.field_145848_d + d.getOffsetY(), tile.field_145849_e + d.getOffsetZ());
    }

    public static CompoundHeatCables getHeatCond(TileEntity tile, VecInt d) {
        if (tile instanceof IHeatTile) {
            return ((IHeatTile)tile).getHeatCond(d.getOpposite());
        }
        if (tile instanceof TileMultipart) {
            CompoundHeatCables comp = null;
            for (TMultiPart m : ((TileMultipart)tile).jPartList()) {
                if (!(m instanceof IHeatMultipart)) continue;
                if (comp == null) {
                    comp = new CompoundHeatCables(((IHeatMultipart)m).getHeatConductor());
                    continue;
                }
                comp.add(((IHeatMultipart)m).getHeatConductor());
            }
            return comp;
        }
        return null;
    }

    public static CompoundElectricCables getElectricCond(TileEntity tile, VecInt f, int tier) {
        if (tile instanceof TileMultipart) {
            CompoundElectricCables cab = null;
            for (TMultiPart m : ((TileMultipart)tile).jPartList()) {
                if (!(m instanceof IElectricMultiPart) || ((IElectricMultiPart)m).getElectricConductor(tier) == null) continue;
                if (cab == null) {
                    cab = new CompoundElectricCables(((IElectricMultiPart)m).getElectricConductor(tier));
                    continue;
                }
                cab.add(((IElectricMultiPart)m).getElectricConductor(tier));
            }
            return cab;
        }
        if (tile instanceof IElectricTile) {
            return ((IElectricTile)tile).getConds(f, tier);
        }
        return null;
    }

    public static IEnergyInterface getInterface(TileEntity t, VecInt i, int tier) {
        return InteractionHelper.processTile(t, i, tier);
    }

    public static boolean isConductor(TileEntity tile, int tier) {
        return MgUtils.getElectricCond(tile, VecInt.NULL_VECTOR, tier) != null;
    }

    public static List<TileEntity> getNeig(TileEntity t) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (MgDirection d : MgDirection.values()) {
            TileEntity f = MgUtils.getTileEntity(t, d);
            if (f == null) continue;
            list.add(f);
        }
        return list;
    }

    public static boolean isMineableBlock(World w, BlockInfo info) {
        if (info.getBlock() == Blocks.field_150350_a) {
            return false;
        }
        if (info.getBlock() instanceof BlockLiquid) {
            return false;
        }
        if (info.getBlock() instanceof BlockFluidBase) {
            return false;
        }
        if (Block.func_149680_a((Block)info.getBlock(), (Block)Blocks.field_150474_ac)) {
            return false;
        }
        if (info.getBlock() == Blocks.field_150427_aO) {
            return false;
        }
        if (info.getBlock() == Blocks.field_150384_bq) {
            return false;
        }
        if (info.getBlock() == Blocks.field_150378_br) {
            return false;
        }
        return info.getBlock().func_149712_f(w, info.getX(), info.getY(), info.getZ()) != -1.0f;
    }

    public static boolean areEcuals(FluidStack a, FluidStack b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return FluidRegistry.getFluidName((FluidStack)a).equalsIgnoreCase(FluidRegistry.getFluidName((FluidStack)b));
    }

    public static boolean areEcuals(ItemStack a, ItemStack b, boolean meta) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null && a.func_77973_b() != null && b.func_77973_b() != null) {
            if (OreDictionary.itemMatches((ItemStack)a, (ItemStack)b, (boolean)meta)) {
                return true;
            }
            int[] c = OreDictionary.getOreIDs((ItemStack)a);
            int[] d = OreDictionary.getOreIDs((ItemStack)b);
            if (c.length > 0 && d.length > 0) {
                for (int i : c) {
                    for (int j : d) {
                        if (i != j) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static TileEntity getTileEntity(World w, VecInt v) {
        return w.func_147438_o(v.getX(), v.getY(), v.getZ());
    }

    public static boolean contains(MgDirection[] vec, MgDirection d) {
        for (MgDirection dir : vec) {
            if (dir != d) continue;
            return true;
        }
        return false;
    }

    public static IElectricPole getElectricPole(TileEntity tile) {
        if (tile instanceof ITileElectricPole) {
            if (((ITileElectricPole)tile).getMainTile() == null) {
                return null;
            }
            if (((ITileElectricPole)tile).getMainTile() == tile) {
                return ((ITileElectricPole)tile).getPoleConnection();
            }
            return ((ITileElectricPole)tile).getMainTile().getPoleConnection();
        }
        return null;
    }

    public static IOpticFiber getOpticFiber(TileEntity tile, MgDirection dir) {
        if (tile instanceof TileMultipart) {
            for (TMultiPart p : ((TileMultipart)tile).jPartList()) {
                if (!(p instanceof IOpticFiber)) continue;
                return (IOpticFiber)p;
            }
        }
        return null;
    }
}

