/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.google.common.base.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class VecDouble {
    public static final VecDouble NULL_VECTOR = new VecDouble(0, 0, 0);
    protected double x;
    protected double y;
    protected double z;

    public VecDouble(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VecDouble(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VecDouble(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VecDouble(NBTTagCompound nbt, String name) {
        this(nbt.func_74769_h(name + "_x"), nbt.func_74769_h(name + "_y"), nbt.func_74769_h(name + "_z"));
    }

    public VecDouble(double[] ar) {
        this(ar[0], ar[1], ar[2]);
    }

    public VecDouble(VecInt vec) {
        this(vec.getX(), vec.getY(), vec.getZ());
    }

    public VecDouble(TileEntity t) {
        this(t.field_145851_c, t.field_145848_d, t.field_145849_e);
    }

    public static VecDouble getConnection(MgDirection d) {
        return new VecDouble(d.getOffsetX(), d.getOffsetY(), d.getOffsetZ());
    }

    public static VecDouble getConnection(ForgeDirection d) {
        return new VecDouble(d.offsetX, d.offsetY, d.offsetZ);
    }

    public VecDouble getOpposite() {
        return new VecDouble(-this.x, -this.y, -this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VecDouble)) {
            return false;
        }
        VecDouble vec = (VecDouble)obj;
        return this.getX() != vec.getX() ? false : (this.getY() != vec.getY() ? false : this.getZ() == vec.getZ());
    }

    public int hashCode() {
        return (int)((this.getY() + this.getZ() * 31.0) * 31.0 + this.getX());
    }

    public double compareTo(VecDouble vec) {
        return this.getY() == vec.getY() ? (this.getZ() == vec.getZ() ? this.getX() - vec.getX() : this.getZ() - vec.getZ()) : this.getY() - vec.getY();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }

    public VecDouble multiply(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
        return this;
    }

    public VecDouble add(VecDouble v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public VecDouble add(double a, double b, double c) {
        this.x += a;
        this.y += b;
        this.z += c;
        return this;
    }

    public VecDouble copy() {
        return new VecDouble(this.x, this.y, this.z);
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public void save(NBTTagCompound nbt, String name) {
        nbt.func_74780_a(name + "_x", this.x);
        nbt.func_74780_a(name + "_y", this.y);
        nbt.func_74780_a(name + "_z", this.x);
    }
}

