/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.api.util;

import com.cout970.magneticraft.api.util.MgDirection;
import com.google.common.base.Objects;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class VecInt {
    public static final VecInt NULL_VECTOR = new VecInt(0, 0, 0);
    protected int x;
    protected int y;
    protected int z;

    public VecInt(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public VecInt(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public VecInt(int[] ar) {
        this(ar[0], ar[1], ar[2]);
    }

    public VecInt(TileEntity tile) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public VecInt(EntityPlayerMP pl) {
        this(pl.field_70165_t, pl.field_70163_u, pl.field_70161_v);
    }

    public VecInt(NBTTagCompound nbt, String name) {
        this(nbt.func_74762_e(name + "_x"), nbt.func_74762_e(name + "_y"), nbt.func_74762_e(name + "_z"));
    }

    public static VecInt fromDirection(MgDirection d) {
        return new VecInt(d.getOffsetX(), d.getOffsetY(), d.getOffsetZ());
    }

    public static VecInt getConnexion(ForgeDirection d) {
        return new VecInt(d.offsetX, d.offsetY, d.offsetZ);
    }

    public VecInt getOpposite() {
        return new VecInt(-this.x, -this.y, -this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VecInt)) {
            return false;
        }
        VecInt vecInt = (VecInt)obj;
        return this.getX() != vecInt.getX() ? false : (this.getY() != vecInt.getY() ? false : this.getZ() == vecInt.getZ());
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    public int compareTo(VecInt vec) {
        return this.getY() == vec.getY() ? (this.getZ() == vec.getZ() ? this.getX() - vec.getX() : this.getZ() - vec.getZ()) : this.getY() - vec.getY();
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("x", this.getX()).add("y", this.getY()).add("z", this.getZ()).toString();
    }

    public MgDirection toMgDirection() {
        for (MgDirection d : MgDirection.values()) {
            if (d.getOffsetX() != this.x || d.getOffsetY() != this.y || d.getOffsetZ() != this.z) continue;
            return d;
        }
        return null;
    }

    public VecInt multiply(int i) {
        this.x *= i;
        this.y *= i;
        this.z *= i;
        return this;
    }

    public VecInt add(VecInt v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public VecInt add(int a, int b, int c) {
        this.x += a;
        this.y += b;
        this.z += c;
        return this;
    }

    public VecInt copy() {
        return new VecInt(this.x, this.y, this.z);
    }

    public void save(NBTTagCompound nbt) {
        nbt.func_74768_a("X", this.x);
        nbt.func_74768_a("Y", this.y);
        nbt.func_74768_a("Z", this.z);
    }

    public static VecInt load(NBTTagCompound nbt) {
        return new VecInt(nbt.func_74762_e("X"), nbt.func_74762_e("Y"), nbt.func_74762_e("Z"));
    }

    public int[] intArray() {
        return new int[]{this.x, this.y, this.z};
    }

    public int squareDistance() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void save(NBTTagCompound nbt, String name) {
        nbt.func_74768_a(name + "_x", this.x);
        nbt.func_74768_a(name + "_y", this.y);
        nbt.func_74768_a(name + "_z", this.z);
    }

    public TileEntity getTileEntity(World w) {
        return w.func_147438_o(this.x, this.y, this.z);
    }
}

