/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.api.electricity.BufferedConductor;
import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompProgresBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileCrusher;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiCrusher
extends GuiBasic {
    public GuiCrusher(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponenets() {
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/crusher.png")));
        this.comp.add(new CompEnergyBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar.png"), new GuiPoint(23, 16)));
        this.comp.add(new CompStorageBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar.png"), new GuiPoint(31, 16)));
        this.comp.add(new CompProgresBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/progresbar1.png"), new GuiPoint(75, 31), ((TileCrusher)this.tile).getProgresBar()));
    }

    public class CompStorageBar
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompStorageBar(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            BufferedConductor c;
            if (tile instanceof TileCrusher && (c = ((TileCrusher)tile).cond) instanceof BufferedConductor) {
                int scale = c.storage * 50 / c.maxStorage;
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (50 - scale), 59, 50 - scale, 11, scale, 70, 50);
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileCrusher) {
                BufferedConductor c = ((TileCrusher)tile).cond;
                if (c == null) {
                    return;
                }
                if (gui.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 11, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format("%.3fkJ", Float.valueOf((float)c.getStorage() / 1000.0f)));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }

    public class CompEnergyBar
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompEnergyBar(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileCrusher) {
                BufferedConductor c = ((TileCrusher)tile).cond;
                int scale = (int)(c.getVoltage() >= 240.0 ? 50.0 : 50.0 * (c.getVoltage() / 240.0));
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (50 - scale), 25, 50 - scale, 5, scale, 70, 50);
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileCrusher) {
                BufferedConductor c = ((TileCrusher)tile).cond;
                if (c == null) {
                    return;
                }
                if (gui.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add((int)c.getVoltage() + "V");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

