/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButtonRedstoneControl;
import com.cout970.magneticraft.client.gui.component.CompEnergyBar;
import com.cout970.magneticraft.client.gui.component.CompEnergyTrackerBar;
import com.cout970.magneticraft.client.gui.component.CompFluidRender;
import com.cout970.magneticraft.client.gui.component.CompStorageBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileSteamEngine;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiSteamEngine
extends GuiBasic {
    public GuiSteamEngine(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponenets() {
        this.comp.add(new CompBackground(new ResourceLocation("magneticraft:textures/gui/steam_engine.png")));
        this.comp.add(new CompEnergyBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar.png"), new GuiPoint(23, 16), ((TileSteamEngine)this.tile).cond));
        this.comp.add(new CompStorageBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar.png"), new GuiPoint(31, 16), ((TileSteamEngine)this.tile).cond));
        this.comp.add(new CompFluidRender(((TileSteamEngine)this.tile).tank, new GuiPoint(66, 25), new GuiPoint(84, 64), new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/tank.png")));
        this.comp.add(new CompInfoDisplay(new GuiPoint(90, 25)));
        this.comp.add(new CompEnergyTrackerBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/productionbar.png"), new GuiPoint(47, 20), ((TileSteamEngine)this.tile).getEnergyTracker()));
        this.comp.add(new CompSteamEngine(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/consumptionbar.png"), new GuiPoint(56, 20)));
        this.comp.add(new CompButtonRedstoneControl(new GuiPoint(150, 8)));
    }

    public class CompSteamEngine
    implements IGuiComp {
        public ResourceLocation texture;
        public GuiPoint pos;

        public CompSteamEngine(ResourceLocation tex, GuiPoint p) {
            this.texture = tex;
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileSteamEngine) {
                TileSteamEngine c = (TileSteamEngine)tile;
                float prod = c.steamConsumitionM / (float)(40 * 20);
                int scale = (int)(44.0f * prod);
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileSteamEngine) {
                TileSteamEngine c = (TileSteamEngine)tile;
                if (gui.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 44)) {
                    ArrayList<String> data = new ArrayList<String>();
                    float prod = c.steamConsumitionM / 20.0f;
                    data.add("Steam consumption " + (int)prod + "mB/t");
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }

    public class CompInfoDisplay
    implements IGuiComp {
        public GuiPoint pos;

        public CompInfoDisplay(GuiPoint p) {
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileSteamEngine) {
                TileSteamEngine g = (TileSteamEngine)tile;
                String s = "Steam: " + String.format("%.2f", Float.valueOf(g.steamConsumitionM / 20.0f)) + "mB/t";
                gui.func_73731_b(GuiSteamEngine.this.field_146289_q, s, gui.xStart + this.pos.x, gui.yStart + this.pos.y + 8, RenderUtil.fromRGB(255, 255, 255));
                s = "Energy: " + (int)(g.electricProductionM / 20.0f) + "W";
                gui.func_73731_b(GuiSteamEngine.this.field_146289_q, s, gui.xStart + this.pos.x, gui.yStart + this.pos.y + 26, RenderUtil.fromRGB(255, 255, 255));
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
        }
    }
}

