/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompEnergyBarMediumVoltage;
import com.cout970.magneticraft.client.gui.component.CompGenericBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileSteamTurbineControl;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;

public class GuiSteamTurbine
extends GuiBasic {
    public GuiSteamTurbine(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponenets() {
        this.comp.add(new CompBackground(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/turbine.png")));
        this.comp.add(new CompGenericBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/efficiencybar.png"), new GuiPoint(29, 20), ((TileSteamTurbineControl)this.tile).getProductionBar()));
        this.comp.add(new CompFluidRender_Turbine((TileSteamTurbineControl)this.tile, new GuiPoint(41, 25), new GuiPoint(59, 64), new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/tank.png")));
        this.comp.add(new CompEnergyBarMediumVoltage(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar2.png"), new GuiPoint(19, 16), ((TileSteamTurbineControl)this.tile).capacity));
    }

    public class CompFluidRender_Turbine
    implements IGuiComp {
        public TileSteamTurbineControl turbine;
        public GuiPoint posA;
        public GuiPoint posB;
        private ResourceLocation background = null;

        public CompFluidRender_Turbine(TileSteamTurbineControl t, GuiPoint a, GuiPoint b, ResourceLocation back) {
            this.turbine = t;
            this.posA = a;
            this.posB = b;
            this.background = back;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (this.turbine != null && this.turbine.getFluidAmount() > 0) {
                IIcon i = FluidRegistry.getFluid((String)"steam").getStillIcon();
                if (i == null) {
                    i = FluidRegistry.WATER.getIcon();
                }
                int scale = this.turbine.getFluidAmount() * Math.abs(this.posA.y - this.posB.y) / this.turbine.getCapacity();
                RenderUtil.bindTexture(TextureMap.field_110575_b);
                gui.func_94065_a(gui.xStart + this.posA.x, gui.yStart + this.posA.y + (Math.abs(this.posA.y - this.posB.y) - scale), i, Math.abs(this.posA.x - this.posB.x), scale);
                if (this.background == null) {
                    return;
                }
                RenderUtil.bindTexture(this.background);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.posA.x - 1, gui.yStart + this.posA.y - 1, 0, 0, Math.abs(this.posA.x - this.posB.x), Math.abs(this.posA.y - this.posB.y), 20, 41);
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (this.turbine != null && this.turbine.getFluidAmount() > 0 && gui.isIn(mx, my, gui.xStart + this.posA.x, gui.yStart + this.posA.y, Math.abs(this.posA.x - this.posB.x), Math.abs(this.posA.y - this.posB.y))) {
                ArrayList<String> data = new ArrayList<String>();
                data.add("Fluid: " + FluidRegistry.getFluidStack((String)"steam", (int)1).getLocalizedName());
                data.add("Amount: " + this.turbine.getFluidAmount());
                gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                RenderHelper.func_74520_c();
            }
        }
    }
}

