/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.CompBackground;
import com.cout970.magneticraft.client.gui.component.CompButtonRedstoneControl;
import com.cout970.magneticraft.client.gui.component.CompEnergyBar;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.tileentity.TileThermopile;
import com.cout970.magneticraft.util.RenderUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiThermopile
extends GuiBasic {
    public GuiThermopile(Container c, TileEntity tile) {
        super(c, tile);
    }

    @Override
    public void initComponenets() {
        this.comp.add(new CompBackground(new ResourceLocation("magneticraft:textures/gui/thermopile.png")));
        this.comp.add(new CompEnergyBar(new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/energybar.png"), new GuiPoint(23, 16), ((TileThermopile)this.tile).cond));
        this.comp.add(new CompHeatDifference(new GuiPoint(32, 20)));
        this.comp.add(new CompButtonRedstoneControl(new GuiPoint(150, 8)));
    }

    public class CompHeatDifference
    implements IGuiComp {
        public ResourceLocation texture0 = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/consumptionbar.png");
        public ResourceLocation texture1 = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/lavabar.png");
        public ResourceLocation texture2 = new ResourceLocation("Magneticraft".toLowerCase() + ":textures/gui/productionbar.png");
        public GuiPoint pos;

        public CompHeatDifference(GuiPoint p) {
            this.pos = p;
        }

        @Override
        public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileThermopile) {
                TileThermopile t = (TileThermopile)tile;
                int scale = (int)(44.0 * Math.min(t.getCurrentFromDiff() / t.getMaxCurrentFromDiff(), 1.0));
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture0);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
                scale = (int)(44.0 * Math.min((double)((float)t.tempHot / 200.0f), 1.0));
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture1);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x + 9, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
                scale = (int)(44.0 * Math.min((double)((float)t.tempCold / 200.0f), 1.0));
                gui.field_146297_k.field_71446_o.func_110577_a(this.texture2);
                RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.pos.x + 18, gui.yStart + this.pos.y + (44 - scale), 0, 44 - scale, 6, scale, 12, 45);
            }
        }

        @Override
        public void onClick(int mx, int my, int buttom, GuiBasic gui) {
        }

        @Override
        public boolean onKey(int n, char key, GuiBasic gui) {
            return false;
        }

        @Override
        public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
            if (tile instanceof TileThermopile) {
                TileThermopile t = (TileThermopile)tile;
                if (gui.isIn(mx, my, gui.xStart + this.pos.x, gui.yStart + this.pos.y, 6, 50)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format("%dW", (int)t.getCurrentFromDiff()));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                } else if (gui.isIn(mx, my, gui.xStart + this.pos.x + 9, gui.yStart + this.pos.y, 6, 50)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format("Hot Source: %d", t.tempHot));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                } else if (gui.isIn(mx, my, gui.xStart + this.pos.x + 18, gui.yStart + this.pos.y, 6, 50)) {
                    ArrayList<String> data = new ArrayList<String>();
                    data.add(String.format("Cold Source: %d", t.tempCold));
                    gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
                    RenderHelper.func_74520_c();
                }
            }
        }
    }
}

