/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.client.gui.component;

import com.cout970.magneticraft.client.gui.GuiBasic;
import com.cout970.magneticraft.client.gui.component.GuiPoint;
import com.cout970.magneticraft.client.gui.component.IGuiComp;
import com.cout970.magneticraft.util.RenderUtil;
import com.cout970.magneticraft.util.fluid.TankMg;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;

public class CompFluidRender
implements IGuiComp {
    public TankMg tank;
    public GuiPoint posA;
    public GuiPoint posB;
    private ResourceLocation background = null;

    public CompFluidRender(TankMg t, GuiPoint a, GuiPoint b) {
        this.tank = t;
        this.posA = a;
        this.posB = b;
    }

    public CompFluidRender(TankMg t, GuiPoint a, GuiPoint b, ResourceLocation back) {
        this.tank = t;
        this.posA = a;
        this.posB = b;
        this.background = back;
    }

    @Override
    public void render(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (this.tank != null && this.tank.getFluid() != null) {
            IIcon i = FluidRegistry.getFluid((String)this.tank.getFluid().getFluid().getName()).getStillIcon();
            if (i == null) {
                i = FluidRegistry.WATER.getIcon();
            }
            int scale = this.tank.getFluidAmount() * Math.abs(this.posA.y - this.posB.y) / this.tank.getCapacity();
            RenderUtil.bindTexture(TextureMap.field_110575_b);
            gui.func_94065_a(gui.xStart + this.posA.x, gui.yStart + this.posA.y + (Math.abs(this.posA.y - this.posB.y) - scale), i, Math.abs(this.posA.x - this.posB.x), scale);
            if (this.background == null) {
                return;
            }
            RenderUtil.bindTexture(this.background);
            RenderUtil.drawTexturedModalRectScaled(gui.xStart + this.posA.x - 1, gui.yStart + this.posA.y - 1, 0, 0, Math.abs(this.posA.x - this.posB.x), Math.abs(this.posA.y - this.posB.y), 20, 41);
        }
    }

    @Override
    public void onClick(int mx, int my, int buttom, GuiBasic gui) {
    }

    @Override
    public boolean onKey(int n, char key, GuiBasic gui) {
        return false;
    }

    @Override
    public void renderTop(int mx, int my, TileEntity tile, GuiBasic gui) {
        if (this.tank != null && this.tank.getFluid() != null && gui.isIn(mx, my, gui.xStart + this.posA.x, gui.yStart + this.posA.y, Math.abs(this.posA.x - this.posB.x), Math.abs(this.posA.y - this.posB.y))) {
            ArrayList<String> data = new ArrayList<String>();
            data.add("Fluid: " + this.tank.getFluid().getLocalizedName());
            data.add("Amount: " + this.tank.getFluidAmount());
            gui.drawHoveringText2(data, mx - gui.xStart, my - gui.yStart);
            RenderHelper.func_74520_c();
        }
    }
}

