/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.compact.minetweaker;

import com.cout970.magneticraft.api.acces.MgRecipeRegister;
import com.cout970.magneticraft.api.acces.RecipeRefinery;
import com.cout970.magneticraft.compact.minetweaker.MgMinetweaker;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.magneticraft.Refinery")
public class Refinery {
    @ZenMethod
    public static void addRecipe(ILiquidStack in, ILiquidStack out1, ILiquidStack out2, ILiquidStack out3) {
        FluidStack a = MgMinetweaker.toFluid(in);
        FluidStack b = MgMinetweaker.toFluid(out1);
        FluidStack c = MgMinetweaker.toFluid(out2);
        FluidStack d = MgMinetweaker.toFluid(out3);
        if (a == null || b == null || c == null || d == null) {
            return;
        }
        RecipeRefinery r = new RecipeRefinery(a, b, c, d);
        MineTweakerAPI.apply((IUndoableAction)new AddRecipe(r));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack in) {
        FluidStack f = MgMinetweaker.toFluid(in);
        if (f == null) {
            return;
        }
        RecipeRefinery r = RecipeRefinery.getRecipe(f);
        if (r == null) {
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipe(r));
    }

    public static class RemoveRecipe
    implements IUndoableAction {
        private final RecipeRefinery r;

        public RemoveRecipe(RecipeRefinery r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.refinery.remove(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Removing " + this.r;
        }

        public String describeUndo() {
            return "Re-Adding " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.refinery.add(this.r);
        }
    }

    public static class AddRecipe
    implements IUndoableAction {
        private final RecipeRefinery r;

        public AddRecipe(RecipeRefinery r) {
            this.r = r;
        }

        public void apply() {
            MgRecipeRegister.refinery.add(this.r);
        }

        public boolean canUndo() {
            return true;
        }

        public String describe() {
            return "Adding " + this.r;
        }

        public String describeUndo() {
            return "Removing " + this.r;
        }

        public Object getOverrideKey() {
            return null;
        }

        public void undo() {
            MgRecipeRegister.refinery.remove(this.r);
        }
    }
}

