/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.items;

import com.cout970.magneticraft.api.electricity.IBatteryItem;
import com.cout970.magneticraft.api.util.NBTUtils;
import com.cout970.magneticraft.items.ItemBasic;
import com.cout970.magneticraft.items.ItemBlockMg;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemCharged
extends ItemBasic
implements IBatteryItem {
    public int MAX_CHARGE;

    public ItemCharged(String unlocalizedname, int charge) {
        super(unlocalizedname);
        this.MAX_CHARGE = charge;
        this.func_77627_a(true);
        this.func_77656_e(100);
    }

    @Override
    public int getCharge(ItemStack it) {
        int charge = NBTUtils.getInteger("Charge", it);
        it.func_77964_b(this.getMetadataByPercent(charge, this.MAX_CHARGE));
        return charge;
    }

    @Override
    public void discharge(ItemStack stack, int energy) {
        int c = Math.max(this.getCharge(stack) - energy, 0);
        NBTUtils.setInteger("Charge", stack, c);
    }

    @Override
    public int charge(ItemStack stack, int energy) {
        int old = this.getCharge(stack);
        int c = Math.min(old + energy, this.getMaxCharge(stack));
        NBTUtils.setInteger("Charge", stack, c);
        return this.getCharge(stack) - old;
    }

    public int getMetadataByPercent(int energy, int capacity) {
        return 101 - 100 * energy / capacity;
    }

    public void func_150895_a(Item unknown, CreativeTabs tab, List subItems) {
        ItemStack a = new ItemStack((Item)this, 1, this.func_77612_l());
        ((IBatteryItem)a.func_77973_b()).charge(a, this.MAX_CHARGE);
        subItems.add(a);
        subItems.add(new ItemStack((Item)this, 1, 0));
    }

    public void func_77624_a(ItemStack i, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(ItemBlockMg.energy + (float)this.getCharge(i) / 1000.0f + "k" + "J" + " / " + (float)this.MAX_CHARGE / 1000.0f + "k" + "J");
    }

    public int getDamage(ItemStack stack) {
        return this.getMetadataByPercent(this.getCharge(stack), this.MAX_CHARGE);
    }

    @Override
    public int getMaxCharge(ItemStack stack) {
        return this.MAX_CHARGE;
    }

    @Override
    public boolean canAcceptCharge(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canExtractCharge(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }
}

