/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.micro;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ConnectionClass;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricMultiPart;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderCableLow;
import com.cout970.magneticraft.parts.micro.PartElectric;
import com.cout970.magneticraft.parts.micro.PartWireCopper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PartCableLow
extends PartElectric
implements ISidedHollowConnect,
IElectricMultiPart {
    public byte connections;
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    private TileRenderCableLow render;

    public PartCableLow() {
        super(ManagerItems.cablelow);
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Arrays.asList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            if ((this.connections & 1 << i) <= 0) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    public int getHollowSize(int arg0) {
        return 4;
    }

    @Override
    public void create() {
        this.cond = new ElectricConductor(this.getTile(), 0.01){

            @Override
            public VecInt[] getValidConnections() {
                VecInt[] FORGE_DIRECTIONS = new VecInt[]{VecInt.fromDirection(MgDirection.DOWN), VecInt.fromDirection(MgDirection.UP), VecInt.fromDirection(MgDirection.NORTH), VecInt.fromDirection(MgDirection.SOUTH), VecInt.fromDirection(MgDirection.WEST), VecInt.fromDirection(MgDirection.EAST), VecInt.NULL_VECTOR};
                return FORGE_DIRECTIONS;
            }

            @Override
            public boolean isAbleToConnect(IElectricConductor c, VecInt d) {
                if (d.equals(VecInt.NULL_VECTOR)) {
                    return true;
                }
                if (d.toMgDirection() == null) {
                    return false;
                }
                return (c.getConnectionClass(d.getOpposite()) == ConnectionClass.FULL_BLOCK || c.getConnectionClass(d.getOpposite()) == ConnectionClass.CABLE_LOW) && ((TileMultipart)PartCableLow.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.toMgDirection().ordinal())));
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_LOW;
            }
        };
    }

    @Override
    public void updateConnections() {
        this.connections = 0;
        for (MgDirection d : MgDirection.values()) {
            IEnergyInterface inter;
            TileEntity t = MgUtils.getTileEntity(this.getTile(), d);
            CompoundElectricCables c = MgUtils.getElectricCond(t, VecInt.fromDirection(d).getOpposite(), this.getTier());
            if (c != null && this.cond != null) {
                for (IElectricConductor e : c.list()) {
                    if (!e.isAbleToConnect(this.cond, VecInt.fromDirection(d.opposite())) || !this.cond.isAbleToConnect(e, VecInt.fromDirection(d))) continue;
                    this.connections = (byte)(this.connections | 1 << d.ordinal());
                }
            }
            if ((inter = MgUtils.getInterface(t, d.toVecInt().getOpposite(), this.getTier())) == null || !inter.canConnect(d.toVecInt()) || !((TileMultipart)this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.ordinal())))) continue;
            this.connections = (byte)(this.connections | 1 << d.ordinal());
        }
        for (TMultiPart t : this.tile().jPartList()) {
            if (!(t instanceof IElectricMultiPart) || ((IElectricMultiPart)t).getElectricConductor(this.getTier()) == null || !(t instanceof PartWireCopper)) continue;
            this.connections = (byte)(this.connections | 1 << ((PartWireCopper)t).getDirection().ordinal());
        }
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderCableLow();
        }
        this.render.render(this, pos);
    }

    static {
        double w = 0.125;
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

