/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.micro;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ConnectionClass;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricMultiPart;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderCableMedium;
import com.cout970.magneticraft.parts.micro.PartElectric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tileentity.TileEntity;

public class PartCableMedium
extends PartElectric
implements ISidedHollowConnect,
IElectricMultiPart {
    public boolean[] connections = new boolean[6];
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    private TileRenderCableMedium render;

    public PartCableMedium() {
        super(ManagerItems.cablemedium);
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Arrays.asList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; ++i) {
            if (!this.connections[i]) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    public int getHollowSize(int arg0) {
        return 4;
    }

    @Override
    public void update() {
        super.update();
        if (this.tile() == null) {
            return;
        }
        if (this.toUpdate) {
            if (this.cond == null) {
                this.create();
            }
            this.toUpdate = false;
            this.updateConnections();
        }
        if (this.tempNBT != null) {
            this.cond.load(this.tempNBT);
            this.tempNBT = null;
        }
        this.cond.recache();
        this.cond.iterate();
    }

    @Override
    public void create() {
        this.cond = new ElectricConductor(this.getTile(), this.getTier(), 0.05){

            @Override
            public boolean isAbleToConnect(IElectricConductor c, VecInt d) {
                if (c.getConnectionClass(d.getOpposite()) == ConnectionClass.FULL_BLOCK || c.getConnectionClass(d.getOpposite()) == ConnectionClass.Cable_MEDIUM) {
                    if (d.toMgDirection() == null) {
                        return false;
                    }
                    if (((TileMultipart)PartCableMedium.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.toMgDirection().ordinal())))) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.Cable_MEDIUM;
            }
        };
    }

    @Override
    public void updateConnections() {
        Arrays.fill(this.connections, false);
        for (MgDirection d : MgDirection.values()) {
            IEnergyInterface inter;
            TileEntity t = MgUtils.getTileEntity(this.getTile(), d);
            CompoundElectricCables c = MgUtils.getElectricCond(t, VecInt.fromDirection(d).getOpposite(), this.getTier());
            if (c != null) {
                for (IElectricConductor e : c.list()) {
                    if (!e.isAbleToConnect(this.cond, VecInt.fromDirection(d.opposite())) || !this.cond.isAbleToConnect(e, VecInt.fromDirection(d))) continue;
                    this.connections[d.ordinal()] = true;
                }
            }
            if ((inter = MgUtils.getInterface(t, d.toVecInt().getOpposite(), this.getTier())) == null || !inter.canConnect(d.toVecInt()) || !((TileMultipart)this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.ordinal())))) continue;
            this.connections[d.ordinal()] = true;
        }
    }

    @Override
    public int getTier() {
        return 2;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderCableMedium();
        }
        this.render.render(this, pos);
    }

    static {
        double w = 0.1875;
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

