/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.micro;

import buildcraft.api.tools.IToolWrench;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.client.tilerender.TileRenderPipeCopper;
import com.cout970.magneticraft.parts.micro.PartPipe;
import com.cout970.magneticraft.util.fluid.FluidUtils;
import com.cout970.magneticraft.util.fluid.IFluidTransport;
import com.cout970.magneticraft.util.fluid.TankConection;
import com.cout970.magneticraft.util.fluid.TankMg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class PartCopperPipe
extends PartPipe
implements ISidedHollowConnect {
    public boolean[] connections = new boolean[7];
    public static List<Cuboid6> boxes = new ArrayList<Cuboid6>();
    private TileRenderPipeCopper render;
    public static final int MAX_ACCEPT = 180;
    public static final int MAX_EXTRACT = 180;
    public Map<MgDirection, TankConection> tanks = new HashMap<MgDirection, TankConection>();
    public PartPipe.ConnectionMode[] side = new PartPipe.ConnectionMode[]{PartPipe.ConnectionMode.OUTPUT, PartPipe.ConnectionMode.OUTPUT, PartPipe.ConnectionMode.OUTPUT, PartPipe.ConnectionMode.OUTPUT, PartPipe.ConnectionMode.OUTPUT, PartPipe.ConnectionMode.OUTPUT};
    public boolean[] locked = new boolean[6];
    public boolean toUpdate = true;

    public PartCopperPipe() {
        super(ManagerItems.partcopperpipe);
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Arrays.asList(boxes.get(6));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> t2 = new ArrayList<Cuboid6>();
        t2.add(boxes.get(6));
        for (int i = 0; i < 6; ++i) {
            if (!this.connections[i]) continue;
            t2.add(boxes.get(i));
        }
        return t2;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderPipeCopper();
        }
        this.render.render(this, pos);
    }

    public int getHollowSize(int arg0) {
        return 6;
    }

    public void updateConnections() {
        if (this.tile() == null) {
            return;
        }
        this.tanks.clear();
        this.connections = new boolean[6];
        for (MgDirection d : MgDirection.values()) {
            TileEntity t = MgUtils.getTileEntity((TileEntity)this.tile(), d);
            if (FluidUtils.isPipe(t)) {
                IFluidTransport trans = FluidUtils.getFluidTransport(t);
                if (!this.isComaptible(trans) || !this.canConectOnSide(d) || !FluidUtils.getFluidTransport(t).canConectOnSide(d.opposite())) continue;
                this.connections[d.ordinal()] = true;
                continue;
            }
            if (!(t instanceof IFluidHandler) || !this.canConectOnSide(d)) continue;
            this.connections[d.ordinal()] = true;
            this.tanks.put(d, new TankConection((IFluidHandler)t, d.opposite()));
        }
    }

    @Override
    public void update() {
        super.update();
        if (this.toUpdate) {
            this.updateConnections();
            boolean redstone = this.world().func_72864_z(this.x(), this.y(), this.z());
            MgDirection[] mgDirectionArray = MgDirection.values();
            int n = mgDirectionArray.length;
            for (int i = 0; i < n; ++i) {
                MgDirection d = mgDirectionArray[i];
                if (this.locked[d.ordinal()] || !this.connections[d.ordinal()]) continue;
                this.side[d.ordinal()] = redstone ? PartPipe.ConnectionMode.INPUT : PartPipe.ConnectionMode.OUTPUT;
            }
            this.toUpdate = false;
        }
        if (this.world().field_72995_K) {
            return;
        }
        if (this.world().func_82737_E() % 20L == 3L) {
            this.sendDescUpdate();
        }
        if (this.getNetwork() == null) {
            return;
        }
        for (MgDirection d : MgDirection.values()) {
            int space;
            int toD;
            FluidStack f;
            TankConection t;
            if (!this.connections[d.ordinal()]) continue;
            if (this.side[d.ordinal()] == PartPipe.ConnectionMode.OUTPUT) {
                FluidStack df;
                TankConection t2;
                int total = this.getNetwork().getFluidAmount();
                int toD2 = Math.min(180, total);
                if (toD2 <= 0 || this.getNetwork().getFluid() == null || !FluidRegistry.isFluidRegistered((String)this.getNetwork().fluid.getName()) || (t2 = this.tanks.get((Object)d)) == null || (toD2 = Math.min(toD2, t2.fill(t2.side, new FluidStack(this.getNetwork().fluid, toD2), false))) <= 0 || (df = this.drainMg(t2.side.opposite(), toD2, true)) == null) continue;
                t2.fill(t2.side, df, true);
                continue;
            }
            if (this.side[d.ordinal()] != PartPipe.ConnectionMode.INPUT || (t = this.tanks.get((Object)d)) == null || (f = t.drain(t.side, 180, false)) == null || f.getFluid() == null || this.getNetwork().getFluid() != null && this.getNetwork().getFluid().getName() != f.getFluid().getName() || (toD = Math.min(f.amount, space = this.getNetwork().getCapacity() - this.getNetwork().getFluidAmount())) <= 0) continue;
            FluidStack c = t.drain(t.side, toD, false);
            int filled = this.fillMg(MgDirection.UP, c, true);
            t.drain(t.side, filled, true);
        }
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        if (this.getNetwork() == null) {
            return 0;
        }
        return this.getNetwork().manager.fillMg(from, resource, doFill);
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        if (this.getNetwork() == null) {
            return null;
        }
        return this.getNetwork().manager.drainMg_F(from, resource, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        if (this.getNetwork() == null) {
            return null;
        }
        return this.getNetwork().manager.drainMg(from, maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        if (this.getNetwork() == null) {
            return false;
        }
        return this.getNetwork().manager.canFillMg(from, fluid);
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        if (this.getNetwork() == null) {
            return false;
        }
        return this.getNetwork().manager.canDrainMg(from, fluid);
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.getTank())};
    }

    @Override
    public void save(NBTTagCompound nbt) {
        int d;
        super.save(nbt);
        for (d = 0; d < 6; ++d) {
            nbt.func_74768_a("s" + d, this.side[d].ordinal());
        }
        for (d = 0; d < 6; ++d) {
            nbt.func_74757_a("l" + d, this.locked[d]);
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
        int d;
        super.load(nbt);
        for (d = 0; d < 6; ++d) {
            this.side[d] = PartPipe.ConnectionMode.values()[nbt.func_74762_e("s" + d)];
        }
        for (d = 0; d < 6; ++d) {
            this.locked[d] = nbt.func_74767_n("l" + d);
        }
    }

    public void writeDesc(MCDataOutput p) {
        int d;
        super.writeDesc(p);
        for (d = 0; d < 6; ++d) {
            p.writeInt(this.side[d].ordinal());
        }
        for (d = 0; d < 6; ++d) {
            p.writeBoolean(this.locked[d]);
        }
    }

    public void readDesc(MCDataInput p) {
        int d;
        super.readDesc(p);
        for (d = 0; d < 6; ++d) {
            this.side[d] = PartPipe.ConnectionMode.values()[p.readInt()];
        }
        for (d = 0; d < 6; ++d) {
            this.locked[d] = p.readBoolean();
        }
    }

    public void onNeighborChanged() {
        this.toUpdate = true;
        if (this.getNetwork() != null) {
            this.getNetwork().refresh();
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.onNeighborChanged();
    }

    public void onAdded() {
        this.onNeighborChanged();
    }

    public void onRemoved() {
        if (this.getNetwork() != null) {
            this.getNetwork().excludeAndRecalculate(this);
        }
    }

    public boolean activate(EntityPlayer player, MovingObjectPosition hit, ItemStack item) {
        if (item != null && item.func_77973_b() instanceof IToolWrench) {
            Vector3 v = new Vector3(hit.field_72307_f.field_72450_a - (double)hit.field_72311_b, hit.field_72307_f.field_72448_b - (double)hit.field_72312_c, hit.field_72307_f.field_72449_c - (double)hit.field_72309_d);
            for (MgDirection d : MgDirection.values()) {
                if (!this.connections[d.ordinal()] || !PartCopperPipe.isHited(boxes.get(d.ordinal()), v)) continue;
                this.side[d.ordinal()] = PartPipe.ConnectionMode.getNext(this.side[d.ordinal()]);
                this.locked[d.ordinal()] = true;
                if (this.world().field_72995_K) continue;
                this.sendDescUpdate();
            }
        }
        return false;
    }

    public static boolean isHited(Cuboid6 c, Vector3 v) {
        if (c == null || v == null) {
            return false;
        }
        if (((float)c.max.y == (float)v.y || (float)c.min.y == (float)v.y) && c.min.x <= v.x && c.max.x >= v.x && c.min.z <= v.z && c.max.z >= v.z) {
            return true;
        }
        if (((float)c.max.x == (float)v.x || (float)c.min.x == (float)v.x) && c.min.y <= v.y && c.max.y >= v.y && c.min.z <= v.z && c.max.z >= v.z) {
            return true;
        }
        return ((float)c.max.z == (float)v.z || (float)c.min.z == (float)v.z) && c.min.x <= v.x && c.max.x >= v.x && c.min.y <= v.y && c.max.y >= v.y;
    }

    @Override
    public boolean canConectOnSide(MgDirection d) {
        return this.tile().canAddPart((TMultiPart)new NormallyOccludedPart(boxes.get(d.ordinal())));
    }

    @Override
    public boolean isComaptible(IFluidTransport a) {
        return a instanceof PartCopperPipe;
    }

    @Override
    public IFluidTank getTank() {
        if (this.buffer == null) {
            this.buffer = new TankMg((TileEntity)this.tile(), 180);
        }
        return this.buffer;
    }

    static {
        double w = 0.2;
        boxes.clear();
        boxes.add(new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w, 1.0, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, 0.5 - w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w, 1.0));
        boxes.add(new Cuboid6(0.0, 0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 + w, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w));
        boxes.add(new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w));
    }
}

