/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.micro;

import codechicken.multipart.TMultiPart;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricMultiPart;
import com.cout970.magneticraft.parts.micro.MgPart;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;

public abstract class PartElectric
extends MgPart
implements IElectricMultiPart {
    public IElectricConductor cond;
    public boolean toUpdate = true;
    public NBTTagCompound tempNBT;

    public PartElectric(Item i) {
        super(i);
    }

    public abstract void create();

    @Override
    public IElectricConductor getElectricConductor(int t) {
        if (t == -1 || t == this.getTier()) {
            return this.cond;
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.tile() == null) {
            return;
        }
        if (this.toUpdate) {
            if (this.cond == null) {
                this.create();
            }
            this.toUpdate = false;
            this.updateConnections();
        }
        if (this.world().field_72995_K && this.world().func_82737_E() % 10L == 0L) {
            this.updateConnections();
        }
        if (this.tempNBT != null) {
            this.cond.load(this.tempNBT);
            this.tempNBT = null;
        }
        this.cond.recache();
        this.cond.iterate();
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.toUpdate = true;
        if (this.cond != null) {
            this.cond.disconect();
        }
    }

    public void onPartChanged(TMultiPart part) {
        this.onNeighborChanged();
    }

    public void onAdded() {
        this.onNeighborChanged();
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.tile() == null) {
            return;
        }
        if (this.cond != null) {
            this.cond.save(nbt);
        }
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        this.tempNBT = nbt;
    }

    public abstract int getTier();

    public abstract void updateConnections();
}

