/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.parts.micro;

import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.NormallyOccludedPart;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.cout970.magneticraft.ManagerItems;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ConnectionClass;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.tilerender.TileRenderWireCopper;
import com.cout970.magneticraft.parts.micro.PartElectric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;

public abstract class PartWireCopper
extends PartElectric {
    public static List<Cuboid6> Down_Boxes = new ArrayList<Cuboid6>();
    public static List<Cuboid6> Up_Boxes = new ArrayList<Cuboid6>();
    public static List<Cuboid6> North_Boxes = new ArrayList<Cuboid6>();
    public static List<Cuboid6> South_Boxes = new ArrayList<Cuboid6>();
    public static List<Cuboid6> West_Boxes = new ArrayList<Cuboid6>();
    public static List<Cuboid6> East_Boxes = new ArrayList<Cuboid6>();
    private TileRenderWireCopper render;
    private VecInt[] validCon;
    public int Conn = 0;

    public abstract MgDirection getDirection();

    public abstract List<Cuboid6> getBoxes();

    public PartWireCopper() {
        super(ManagerItems.wire_copper);
    }

    @Override
    public void create() {
        this.cond = new ElectricConductor(this.getTile(), 0, 0.01){

            @Override
            public VecInt[] getValidConnections() {
                return PartWireCopper.this.getValidConnexions(PartWireCopper.this.getDirection());
            }

            @Override
            public boolean isAbleToConnect(IElectricConductor c, VecInt d) {
                if (d.equals(VecInt.NULL_VECTOR)) {
                    return true;
                }
                if (d.equals(PartWireCopper.this.getDirection().toVecInt())) {
                    return true;
                }
                if (d.equals(PartWireCopper.this.getDirection().opposite().toVecInt())) {
                    return false;
                }
                MgDirection dir = d.toMgDirection();
                if (dir != null) {
                    return ((TileMultipart)PartWireCopper.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(PartWireCopper.this.getBoxes().get(PartWireCopper.this.getBoxBySide(dir)))) && (c.getConnectionClass(d.getOpposite()) == this.getConnectionClass(d) || c.getConnectionClass(d.getOpposite()) == ConnectionClass.FULL_BLOCK);
                }
                dir = d.copy().add(PartWireCopper.this.getDirection().toVecInt().getOpposite()).toMgDirection();
                if (dir != null) {
                    VecInt g = dir.toVecInt().add(PartWireCopper.this.X(), PartWireCopper.this.Y(), PartWireCopper.this.Z());
                    Block b = PartWireCopper.this.W().func_147439_a(g.getX(), g.getY(), g.getZ());
                    return ((TileMultipart)PartWireCopper.this.getTile()).canAddPart((TMultiPart)new NormallyOccludedPart(PartWireCopper.this.getBoxes().get(PartWireCopper.this.getBoxBySide(dir)))) && PartWireCopper.this.isTranspasable(b) && (c.getConnectionClass(d.getOpposite()) == ConnectionClass.FULL_BLOCK || ConnectionClass.isSlabCompatible(c.getConnectionClass(d.getOpposite()), this.getConnectionClass(d)));
                }
                return false;
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return PartWireCopper.this.ConnectionType();
            }
        };
    }

    public abstract int getBoxBySide(MgDirection var1);

    public ConnectionClass ConnectionType() {
        if (this.getDirection() == MgDirection.DOWN) {
            return ConnectionClass.SLAB_BOTTOM;
        }
        if (this.getDirection() == MgDirection.UP) {
            return ConnectionClass.SLAB_TOP;
        }
        if (this.getDirection() == MgDirection.NORTH) {
            return ConnectionClass.SLAB_NORTH;
        }
        if (this.getDirection() == MgDirection.SOUTH) {
            return ConnectionClass.SLAB_SOUTH;
        }
        if (this.getDirection() == MgDirection.WEST) {
            return ConnectionClass.SLAB_WEST;
        }
        if (this.getDirection() == MgDirection.EAST) {
            return ConnectionClass.SLAB_EAST;
        }
        return ConnectionClass.SLAB_BOTTOM;
    }

    public VecInt[] getValidConnexions(MgDirection dir) {
        if (this.validCon == null) {
            this.validCon = new VecInt[10];
            this.validCon[0] = VecInt.NULL_VECTOR;
            this.validCon[1] = dir.toVecInt();
            int i = 2;
            for (MgDirection d : MgDirection.values()) {
                if (d == dir || d == dir.opposite()) continue;
                this.validCon[i] = d.toVecInt();
                i = (byte)(i + 1);
            }
            for (MgDirection d : MgDirection.values()) {
                if (d == dir || d == dir.opposite()) continue;
                this.validCon[i] = d.toVecInt().copy().add(dir.toVecInt());
                i = (byte)(i + 1);
            }
        }
        return this.validCon;
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public void updateConnections() {
        this.Conn = 0;
        for (MgDirection f : MgDirection.values()) {
            TileEntity target = MgUtils.getTileEntity((TileEntity)this.tile(), f.toVecInt());
            CompoundElectricCables c = MgUtils.getElectricCond(target, f.toVecInt().getOpposite(), this.getTier());
            IEnergyInterface inter = MgUtils.getInterface(target, f.toVecInt().getOpposite(), this.getTier());
            if (c != null) {
                for (IElectricConductor e : c.list()) {
                    if (!this.cond.isAbleToConnect(e, f.toVecInt()) || !e.isAbleToConnect(this.cond, f.toVecInt().getOpposite())) continue;
                    this.Conn |= 1 << f.ordinal();
                }
            }
            for (TMultiPart t : this.tile().jPartList()) {
                if (!(t instanceof PartWireCopper) || t == this || ((PartWireCopper)t).getDirection() != f) continue;
                this.Conn |= 1 << f.ordinal();
            }
            if (inter == null) continue;
            this.Conn |= 1 << f.ordinal();
        }
        for (MgDirection d : MgDirection.values()) {
            VecInt f = d.toVecInt().add(this.getDirection().toVecInt());
            TileEntity target = MgUtils.getTileEntity((TileEntity)this.tile(), f);
            CompoundElectricCables c = MgUtils.getElectricCond(target, f.getOpposite(), this.getTier());
            IEnergyInterface inter = MgUtils.getInterface(target, f.getOpposite(), this.getTier());
            if (c == null && inter == null) continue;
            VecInt g = d.toVecInt().copy().add(this.X(), this.Y(), this.Z());
            Block b = this.W().func_147439_a(g.getX(), g.getY(), g.getZ());
            if (!this.isTranspasable(b)) continue;
            if (c != null) {
                for (IElectricConductor e : c.list()) {
                    if (!this.cond.isAbleToConnect(e, f) || !e.isAbleToConnect(this.cond, f.getOpposite())) continue;
                    this.Conn |= 1 << d.ordinal();
                    this.Conn |= 1 << d.ordinal() + 6;
                }
            }
            if (inter == null) continue;
            this.Conn |= 1 << d.ordinal();
            this.Conn |= 1 << d.ordinal() + 6;
        }
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        MgDirection d = this.getDirection();
        if (!this.world().field_72995_K && !this.world().isSideSolid(this.X() + d.getOffsetX(), this.Y() + d.getOffsetY(), this.Z() + d.getOffsetZ(), d.toForgeDir(), false)) {
            this.tile().dropItems(this.getDrops());
            this.tile().remPart((TMultiPart)this);
        }
    }

    private boolean isTranspasable(Block b) {
        return b == Blocks.field_150350_a;
    }

    @Override
    public String getType() {
        return this.item.func_77658_a() + "_" + this.getDirection().name();
    }

    @Override
    public List<Cuboid6> getOcclusionCubes() {
        return Arrays.asList(this.getBoxes().get(0));
    }

    @Override
    public List<Cuboid6> getCollisionCubes() {
        ArrayList<Cuboid6> l = new ArrayList<Cuboid6>();
        l.add(this.getBoxes().get(0));
        for (MgDirection d : MgDirection.values()) {
            if (this.getBoxBySide(d) == 0 || (this.Conn & 1 << d.ordinal()) <= 0) continue;
            l.add(this.getBoxes().get(this.getBoxBySide(d)));
        }
        return l;
    }

    @Override
    public void renderPart(Vector3 pos) {
        if (this.render == null) {
            this.render = new TileRenderWireCopper();
        }
        this.render.render(this, pos);
    }

    public boolean isUnconnected() {
        return (this.Conn & this.getConMask()) == 0;
    }

    public int getConMask() {
        if (this.getDirection() == MgDirection.DOWN) {
            return 4093;
        }
        if (this.getDirection() == MgDirection.UP) {
            return 4094;
        }
        if (this.getDirection() == MgDirection.NORTH) {
            return 4087;
        }
        if (this.getDirection() == MgDirection.SOUTH) {
            return 4091;
        }
        if (this.getDirection() == MgDirection.WEST) {
            return 4063;
        }
        if (this.getDirection() == MgDirection.EAST) {
            return 4079;
        }
        return 4095;
    }

    static {
        float width = 0.125f;
        float h = 0.1875f;
        Down_Boxes.clear();
        Up_Boxes.clear();
        North_Boxes.clear();
        South_Boxes.clear();
        West_Boxes.clear();
        East_Boxes.clear();
        Down_Boxes.add(new Cuboid6((double)(0.5f - width), 0.0, (double)(0.5f - width), (double)(0.5f + width), (double)h, (double)(0.5f + width)));
        Down_Boxes.add(new Cuboid6((double)(0.5f - width), 0.0, 0.0, (double)(0.5f + width), (double)h, (double)(0.5f - width)));
        Down_Boxes.add(new Cuboid6((double)(0.5f - width), 0.0, (double)(0.5f + width), (double)(0.5f + width), (double)h, 1.0));
        Down_Boxes.add(new Cuboid6(0.0, 0.0, (double)(0.5f - width), (double)(0.5f - width), (double)h, (double)(0.5f + width)));
        Down_Boxes.add(new Cuboid6((double)(0.5f + width), 0.0, (double)(0.5f - width), 1.0, (double)h, (double)(0.5f + width)));
        Up_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(1.0f - h), (double)(0.5f - width), (double)(0.5f + width), 1.0, (double)(0.5f + width)));
        Up_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(1.0f - h), 0.0, (double)(0.5f + width), 1.0, (double)(0.5f - width)));
        Up_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(1.0f - h), (double)(0.5f + width), (double)(0.5f + width), 1.0, 1.0));
        Up_Boxes.add(new Cuboid6(0.0, (double)(1.0f - h), (double)(0.5f - width), (double)(0.5f - width), 1.0, (double)(0.5f + width)));
        Up_Boxes.add(new Cuboid6((double)(0.5f + width), (double)(1.0f - h), (double)(0.5f - width), 1.0, 1.0, (double)(0.5f + width)));
        North_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(0.5f - width), 0.0, (double)(0.5f + width), (double)(0.5f + width), (double)h));
        North_Boxes.add(new Cuboid6((double)(0.5f - width), 0.0, 0.0, (double)(0.5f + width), (double)(0.5f - width), (double)h));
        North_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(0.5f + width), 0.0, (double)(0.5f + width), 1.0, (double)h));
        North_Boxes.add(new Cuboid6(0.0, (double)(0.5f - width), 0.0, (double)(0.5f - width), (double)(0.5f + width), (double)h));
        North_Boxes.add(new Cuboid6((double)(0.5f + width), (double)(0.5f - width), 0.0, 1.0, (double)(0.5f + width), (double)h));
        South_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(0.5f - width), (double)(1.0f - h), (double)(0.5f + width), (double)(0.5f + width), 1.0));
        South_Boxes.add(new Cuboid6((double)(0.5f - width), 0.0, (double)(1.0f - h), (double)(0.5f + width), (double)(0.5f - width), 1.0));
        South_Boxes.add(new Cuboid6((double)(0.5f - width), (double)(0.5f + width), (double)(1.0f - h), (double)(0.5f + width), 1.0, 1.0));
        South_Boxes.add(new Cuboid6(0.0, (double)(0.5f - width), (double)(1.0f - h), (double)(0.5f - width), (double)(0.5f + width), 1.0));
        South_Boxes.add(new Cuboid6((double)(0.5f + width), (double)(0.5f - width), (double)(1.0f - h), 1.0, (double)(0.5f + width), 1.0));
        West_Boxes.add(new Cuboid6(0.0, (double)(0.5f - width), (double)(0.5f - width), (double)h, (double)(0.5f + width), (double)(0.5f + width)));
        West_Boxes.add(new Cuboid6(0.0, 0.0, (double)(0.5f - width), (double)h, (double)(0.5f - width), (double)(0.5f + width)));
        West_Boxes.add(new Cuboid6(0.0, (double)(0.5f + width), (double)(0.5f - width), (double)h, 1.0, (double)(0.5f + width)));
        West_Boxes.add(new Cuboid6(0.0, (double)(0.5f - width), 0.0, (double)h, (double)(0.5f + width), (double)(0.5f - width)));
        West_Boxes.add(new Cuboid6(0.0, (double)(0.5f - width), (double)(0.5f + width), (double)h, (double)(0.5f + width), 1.0));
        East_Boxes.add(new Cuboid6((double)(1.0f - h), (double)(0.5f - width), (double)(0.5f - width), 1.0, (double)(0.5f + width), (double)(0.5f + width)));
        East_Boxes.add(new Cuboid6((double)(1.0f - h), 0.0, (double)(0.5f - width), 1.0, (double)(0.5f - width), (double)(0.5f + width)));
        East_Boxes.add(new Cuboid6((double)(1.0f - h), (double)(0.5f + width), (double)(0.5f - width), 1.0, 1.0, (double)(0.5f + width)));
        East_Boxes.add(new Cuboid6((double)(1.0f - h), (double)(0.5f - width), 0.0, 1.0, (double)(0.5f + width), (double)(0.5f - width)));
        East_Boxes.add(new Cuboid6((double)(1.0f - h), (double)(0.5f - width), (double)(0.5f + width), 1.0, (double)(0.5f + width), 1.0));
    }
}

