/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerNetwork;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.messages.MessageNBTUpdate;
import com.cout970.magneticraft.tileentity.Tile1_8Updater;
import com.cout970.magneticraft.util.ITileHandlerNBT;
import com.cout970.magneticraft.util.tile.RedstoneControl;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileBase
extends Tile1_8Updater
implements ITileHandlerNBT {
    public boolean powered;
    public RedstoneControl redstone = RedstoneControl.NORMAL;

    public void onNeigChange() {
        this.powered = this.isPowered();
    }

    public void onBlockBreaks() {
    }

    public void sendUpdateToClient() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        this.saveInServer(nbt);
        MessageNBTUpdate message = new MessageNBTUpdate(this, nbt);
        for (Object obj : this.field_145850_b.field_73010_i) {
            EntityPlayerMP player;
            if (!(obj instanceof EntityPlayerMP) || this.getDistanceSquaredFrom(player = (EntityPlayerMP)obj, this) > 16384) continue;
            ManagerNetwork.INSTANCE.sendTo((IMessage)message, player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 16384.0;
    }

    protected int getDistanceSquaredFrom(EntityPlayerMP pl, TileBase tile) {
        VecInt vecPl = new VecInt(pl);
        VecInt vecTE = new VecInt(tile);
        return vecPl.add(vecTE.getOpposite()).squareDistance();
    }

    public void setRedstoneControl(RedstoneControl newState) {
        this.redstone = newState;
        this.onNeigChange();
        this.sendUpdateToClient();
    }

    public boolean isControled() {
        if (this.redstone == RedstoneControl.NORMAL) {
            return !this.powered;
        }
        if (this.redstone == RedstoneControl.INVERSE) {
            return this.powered;
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.redstone = RedstoneControl.values()[nbt.func_74771_c("RedstoneControl")];
        this.powered = nbt.func_74767_n("Powered");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("RedstoneControl", (byte)this.redstone.ordinal());
        nbt.func_74757_a("Powered", this.powered);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        S35PacketUpdateTileEntity p = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        return p;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static RedstoneControl step(RedstoneControl state) {
        return state == RedstoneControl.NORMAL ? RedstoneControl.INVERSE : (state == RedstoneControl.INVERSE ? RedstoneControl.DISBLE : RedstoneControl.NORMAL);
    }

    @Override
    public void saveInServer(NBTTagCompound nbt) {
        this.func_145841_b(nbt);
    }

    @Override
    public void loadInClient(NBTTagCompound nbt) {
        this.func_145839_a(nbt);
    }
}

