/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IBatteryItem;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.IBlockWithData;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileBattery
extends TileConductorLow
implements IGuiSync,
IInventoryManaged,
ISidedInventory,
IBlockWithData {
    private InventoryComponent inv = new InventoryComponent(this, 2, "Battery");
    public static int BATTERY_CHARGE_SPEED = (int)EnergyConversor.RFtoW(400.0);

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this){
            public int storage;
            public int maxStorage;
            public double min;
            public double max;
            {
                this.storage = 0;
                this.maxStorage = (int)EnergyConversor.RFtoW(2000000.0);
                this.min = 180.0;
                this.max = 200.0;
            }

            @Override
            public void iterate() {
                super.iterate();
                if (!TileBattery.this.isControled()) {
                    return;
                }
                if (this.getVoltage() > this.max && this.storage < this.maxStorage) {
                    int change = (int)Math.min((this.getVoltage() - this.max) * 80.0, EnergyConversor.RFtoW(400.0));
                    change = Math.min(change, this.maxStorage - this.storage);
                    this.drainPower(change);
                    this.storage += change;
                } else if (this.getVoltage() < this.min && this.storage > 0) {
                    int change = (int)Math.min((this.min - this.getVoltage()) * 80.0, EnergyConversor.RFtoW(400.0));
                    change = Math.min(change, this.storage);
                    this.applyPower(change);
                    this.storage -= change;
                }
            }

            @Override
            public int getStorage() {
                return this.storage;
            }

            @Override
            public int getMaxStorage() {
                return this.maxStorage;
            }

            @Override
            public void setStorage(int charge) {
                this.storage = charge;
            }

            @Override
            public void applyCharge(int charge) {
                this.storage += charge;
                if (this.storage > this.maxStorage) {
                    this.storage = this.maxStorage;
                }
            }

            @Override
            public void drainCharge(int charge) {
                this.storage -= charge;
                if (this.storage < 0) {
                    this.storage = 0;
                }
            }

            @Override
            public void save(NBTTagCompound nbt) {
                super.save(nbt);
                nbt.func_74768_a("Storage", this.storage);
            }

            @Override
            public void load(NBTTagCompound nbt) {
                super.load(nbt);
                this.storage = nbt.func_74762_e("Storage");
            }
        };
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            IBatteryItem b;
            ItemStack i;
            int meta;
            int amount;
            if (this.field_145850_b.func_82737_E() % 40L == 0L && (amount = (int)Math.floor((float)this.cond.getStorage() * 11.0f / (float)this.cond.getMaxStorage())) != (meta = this.func_145832_p())) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, amount, 3);
            }
            if ((i = this.getInv().func_70301_a(0)) != null && i.func_77973_b() instanceof IBatteryItem && (b = (IBatteryItem)i.func_77973_b()).canAcceptCharge(i)) {
                int canFill = Math.min(b.getMaxCharge(i) - b.getCharge(i), this.cond.getStorage());
                if ((canFill = Math.min(canFill, BATTERY_CHARGE_SPEED)) > 0) {
                    b.charge(i, canFill);
                    this.cond.drainCharge(canFill);
                }
            }
            if ((i = this.getInv().func_70301_a(1)) != null && i.func_77973_b() instanceof IBatteryItem && (b = (IBatteryItem)i.func_77973_b()).canExtractCharge(i)) {
                int canDrain = Math.min(b.getCharge(i), this.cond.getMaxStorage() - this.cond.getStorage());
                if ((canDrain = Math.min(canDrain, BATTERY_CHARGE_SPEED)) > 0) {
                    b.discharge(i, canDrain);
                    this.cond.applyCharge(canDrain);
                }
            }
        }
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage() & 0xFFFF);
        craft.func_71112_a(cont, 2, (this.cond.getStorage() & 0xFFFF0000) >>> 16);
    }

    @Override
    public void getGUINetworkData(int i, int value) {
        if (i == 0) {
            this.cond.setVoltage(value);
        }
        if (i == 1) {
            this.cond.setStorage(value & 0xFFFF);
        }
        if (i == 2) {
            this.cond.setStorage(this.cond.getStorage() | value << 16);
        }
    }

    public int[] func_94128_d(int s) {
        if (s == 0 || s == 1) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return true;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return true;
    }

    @Override
    public void saveData(NBTTagCompound nbt) {
        nbt.func_74768_a("Stored", this.cond.getStorage());
    }

    @Override
    public void loadData(NBTTagCompound nbt) {
        this.cond.setStorage(nbt.func_74762_e("Stored"));
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
    }
}

