/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.computer.IBusWire;
import com.cout970.magneticraft.api.computer.IComputer;
import com.cout970.magneticraft.api.computer.IHardwareProvider;
import com.cout970.magneticraft.api.computer.IModuleCPU;
import com.cout970.magneticraft.api.computer.IModuleMemoryController;
import com.cout970.magneticraft.api.computer.IModuleROM;
import com.cout970.magneticraft.api.computer.IPeripheral;
import com.cout970.magneticraft.api.computer.impl.ModuleDisckDrive;
import com.cout970.magneticraft.api.computer.impl.ModuleHardDrive;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.api.util.VecIntUtil;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.ITileHandlerNBT;
import com.cout970.magneticraft.util.InventoryComponent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileComputer
extends TileBase
implements IGuiListener,
IGuiSync,
IComputer,
IBusWire,
ITileHandlerNBT {
    private IModuleCPU procesor;
    private IModuleMemoryController memory;
    private IModuleROM rom;
    private ModuleHardDrive hardDrive;
    private ModuleDisckDrive floppyDrive;
    private boolean isRuning;
    public int addres = 0;
    private InventoryComponent inv = new InventoryComponent(this, 5, "Computer"){

        @Override
        public void func_70299_a(int slot, ItemStack itemStack) {
            this.inventory[slot] = itemStack;
            if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
                itemStack.field_77994_a = this.func_70297_j_();
            }
            this.func_70296_d();
            if (slot == 3) {
                TileComputer.this.hardDrive.insertDisk(itemStack);
            }
            if (slot == 4) {
                TileComputer.this.floppyDrive.insertDisk(itemStack);
            }
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }
    };
    public IPeripheral motherboard = new IPeripheral(){

        @Override
        public int getAddress() {
            return TileComputer.this.addres;
        }

        @Override
        public void setAddress(int address) {
            TileComputer.this.addres = address;
        }

        @Override
        public boolean isActive() {
            return TileComputer.this.procesor != null && TileComputer.this.memory != null && TileComputer.this.rom != null;
        }

        @Override
        public void writeByte(int pointer, int data) {
        }

        @Override
        public int readByte(int pointer) {
            return 0;
        }

        @Override
        public TileEntity getParent() {
            return TileComputer.this;
        }

        @Override
        public String getName() {
            return "Computer";
        }
    };

    public TileComputer() {
        this.hardDrive = new ModuleHardDrive(this);
        this.floppyDrive = new ModuleDisckDrive(this);
    }

    @Override
    public void onBlockBreaks() {
        for (int i = 0; i < this.getInv().func_70302_i_(); ++i) {
            if (this.getInv().func_70301_a(i) == null) continue;
            BlockMg.dropItem(this.getInv().func_70301_a(i), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        long time = System.nanoTime();
        if (this.motherboard.isActive()) {
            this.procesor.iterate();
            this.hardDrive.iterate();
            this.floppyDrive.iterate();
        }
        if (this.field_145850_b.func_82737_E() % 100L == 0L) {
            this.chechHardware();
            this.sendUpdateToClient();
        }
    }

    @Override
    public Packet func_145844_m() {
        return null;
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
    }

    private void chechHardware() {
        ItemStack cpu = this.getInv().func_70301_a(0);
        ItemStack ram = this.getInv().func_70301_a(1);
        ItemStack rom = this.getInv().func_70301_a(2);
        boolean hasCpu = false;
        boolean hasRam = false;
        boolean hasRom = false;
        if (cpu == null || ram == null || rom == null) {
            this.procesor = null;
            this.memory = null;
            this.rom = null;
            return;
        }
        IHardwareProvider.ModuleType m = null;
        if (cpu.func_77973_b() instanceof IHardwareProvider && (m = ((IHardwareProvider)cpu.func_77973_b()).getModuleType(cpu)) == IHardwareProvider.ModuleType.CPU) {
            hasCpu = true;
        }
        if (ram.func_77973_b() instanceof IHardwareProvider && (m = ((IHardwareProvider)ram.func_77973_b()).getModuleType(ram)) == IHardwareProvider.ModuleType.RAM) {
            hasRam = true;
        }
        if (rom.func_77973_b() instanceof IHardwareProvider && (m = ((IHardwareProvider)rom.func_77973_b()).getModuleType(rom)) == IHardwareProvider.ModuleType.ROM) {
            hasRom = true;
        }
        if (hasCpu && hasRam && hasRom) {
            this.weldHardware();
        } else {
            this.procesor = null;
            this.memory = null;
            this.rom = null;
        }
    }

    public void weldHardware() {
        if (!this.motherboard.isActive()) {
            this.procesor = (IModuleCPU)((IHardwareProvider)this.getInv().func_70301_a(0).func_77973_b()).getHardware(this.getInv().func_70301_a(0));
            this.memory = (IModuleMemoryController)((IHardwareProvider)this.getInv().func_70301_a(1).func_77973_b()).getHardware(this.getInv().func_70301_a(1));
            this.rom = (IModuleROM)((IHardwareProvider)this.getInv().func_70301_a(2).func_77973_b()).getHardware(this.getInv().func_70301_a(2));
            this.procesor.connectMemory(this.memory);
            this.memory.setComputer(this);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isRuning = nbt.func_74767_n("ON");
        this.addres = nbt.func_74762_e("Address");
        this.floppyDrive.load(nbt);
        this.hardDrive.load(nbt);
        this.getInv().readFromNBT(nbt);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            if (!this.motherboard.isActive()) {
                this.chechHardware();
            }
            if (this.motherboard.isActive()) {
                this.procesor.loadRegisters(nbt);
                this.memory.loadMemory(nbt);
                this.floppyDrive.load(nbt);
                this.hardDrive.load(nbt);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("ON", this.isRunning());
        nbt.func_74768_a("Address", this.addres);
        this.floppyDrive.save(nbt);
        this.hardDrive.save(nbt);
        this.getInv().writeToNBT(nbt);
        if (this.motherboard.isActive()) {
            this.procesor.saveRegisters(nbt);
            this.memory.saveMemory(nbt);
            this.floppyDrive.save(nbt);
            this.hardDrive.save(nbt);
        }
    }

    @Override
    public void onMessageReceive(int id, int dato) {
        if (this.motherboard.isActive()) {
            if (id == 0) {
                if (!this.procesor.isRunning()) {
                    this.procesor.start();
                    this.rom.loadToRAM(this.memory);
                    this.sendUpdateToClient();
                }
            } else if (id == 1) {
                this.procesor.stop();
                this.procesor.start();
                this.rom.loadToRAM(this.memory);
                this.sendUpdateToClient();
            } else if (id == 2) {
                this.procesor.stop();
                this.sendUpdateToClient();
            }
        }
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, this.isRunning() ? 1 : 0);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.isRuning = value == 1;
        }
    }

    @Override
    public IModuleCPU getCPU() {
        return this.procesor;
    }

    @Override
    public IModuleMemoryController getMemory() {
        return this.memory;
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public boolean isRunning() {
        if (!this.field_145850_b.field_72995_K) {
            this.isRuning = this.motherboard.isActive() && this.procesor.isRunning();
        }
        return this.isRuning;
    }

    @Override
    public TileEntity getParent() {
        return this;
    }

    @Override
    public IPeripheral[] getPeripherals() {
        return new IPeripheral[]{this.motherboard, this.hardDrive, this.floppyDrive};
    }

    @Override
    public VecInt[] getValidConnections() {
        return VecIntUtil.FORGE_DIRECTIONS;
    }

    @Override
    public void saveInServer(NBTTagCompound nbt) {
        nbt.func_74757_a("ON", this.isRunning());
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public void loadInClient(NBTTagCompound nbt) {
        this.isRuning = nbt.func_74767_n("ON");
        this.getInv().readFromNBT(nbt);
    }
}

