/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.conveyor.ConveyorSide;
import com.cout970.magneticraft.api.conveyor.IConveyor;
import com.cout970.magneticraft.api.conveyor.ItemBox;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.MgBeltUtils;
import com.cout970.magneticraft.util.Orientation;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileConveyorBelt
extends TileBase
implements IConveyor {
    public ConveyorSide left = new ConveyorSide(this, true);
    public ConveyorSide right = new ConveyorSide(this, false);
    public long time;

    @Override
    public MgDirection getDir() {
        return this.getOrientation().getDirection();
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (ItemBox b : this.left.content) {
            BlockMg.dropItem(b.getContent(), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
        for (ItemBox b : this.right.content) {
            BlockMg.dropItem(b.getContent(), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.moveCole(this.left);
        this.moveCole(this.right);
        this.time = System.currentTimeMillis();
        if (this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.sendUpdateToClient();
        }
    }

    private void moveCole(ConveyorSide side) {
        if (this.field_145850_b.func_82737_E() % 10L == 0L) {
            Arrays.fill(side.spaces, false);
        }
        for (int i = 0; i < side.content.size(); ++i) {
            int new_pos;
            ItemBox b = side.content.get(i);
            if (b.lastTick == this.field_145850_b.func_82737_E()) continue;
            b.lastTick = this.field_145850_b.func_82737_E();
            if (b.getPosition() < 15) {
                side.addvance(b);
                continue;
            }
            TileEntity t = ConveyorSide.getFrontConveyor(this);
            if (!MgBeltUtils.isBelt(t)) continue;
            IConveyor con = (IConveyor)t;
            IConveyor.BeltInteraction iter = IConveyor.BeltInteraction.InterBelt(this.getDir(), con.getDir());
            if (iter == IConveyor.BeltInteraction.DIRECT) {
                if (b.getPosition() < 16) {
                    side.addvance(b);
                }
                if (b.getPosition() != 16) continue;
                con.getSideLane(side.isLeft).setSpace(0, false);
                if (!con.inject(0, b, side.isLeft, false)) continue;
                this.extract(b, side.isLeft, false);
                continue;
            }
            if (con.getOrientation().getLevel() != 0) continue;
            if (iter == IConveyor.BeltInteraction.LEFT_T) {
                if (b.getPosition() < 18) {
                    side.addvance(b);
                }
                if (b.getPosition() != 18) continue;
                new_pos = side.isLeft ? 2 : 10;
                con.getSideLane(false).setSpace(new_pos, false);
                if (!con.inject(new_pos, b, false, false)) continue;
                this.extract(b, side.isLeft, false);
                continue;
            }
            if (iter != IConveyor.BeltInteraction.RIGHT_T) continue;
            if (b.getPosition() < 18) {
                side.addvance(b);
            }
            if (b.getPosition() != 18) continue;
            new_pos = side.isLeft ? 10 : 2;
            con.getSideLane(true).setSpace(new_pos, false);
            if (!con.inject(new_pos, b, true, false)) continue;
            this.extract(b, side.isLeft, false);
        }
    }

    @Override
    public boolean extract(ItemBox box, boolean isOnLeft, boolean simulated) {
        ConveyorSide side;
        ConveyorSide conveyorSide = side = isOnLeft ? this.left : this.right;
        if (side.content.contains(box)) {
            if (!simulated) {
                side.content.remove(box);
                side.setSpace(box.getPosition(), false);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean inject(int pos, ItemBox box, boolean isOnLeft, boolean simulated) {
        ConveyorSide side;
        ConveyorSide conveyorSide = side = isOnLeft ? this.left : this.right;
        if (side.hasSpace(pos)) {
            if (!simulated) {
                box.setPosition(pos);
                box.setOnLeft(isOnLeft);
                side.setSpace(pos, true);
                side.content.add(box);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean addItem(MgDirection dir, int pos, ItemBox b, boolean sim) {
        if (b == null) {
            return false;
        }
        boolean onLeft = dir.isPerpendicular(this.getDir()) ? dir == this.getDir().step(MgDirection.UP) : b.isOnLeft();
        boolean ret = this.inject(pos, b, onLeft, sim);
        this.sendUpdateToClient();
        return ret;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.left.save(nbt);
        this.right.save(nbt);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.left.load(nbt);
        this.right.load(nbt);
    }

    @Override
    public TileEntity getParent() {
        return this;
    }

    @Override
    public ConveyorSide getSideLane(boolean left) {
        return left ? this.left : this.right;
    }

    @Override
    public Orientation getOrientation() {
        return Orientation.fromMeta(this.func_145832_p());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)((float)(this.field_145851_c + 1) + 0.3125f), (double)((float)(this.field_145848_d + 1) + 0.3125f), (double)((float)(this.field_145849_e + 1) + 0.3125f));
    }

    @Override
    public boolean removeItem(ItemBox it, boolean isLeft, boolean simulated) {
        boolean ret = this.extract(it, isLeft, simulated);
        if (!simulated) {
            this.sendUpdateToClient();
        }
        return ret;
    }
}

