/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryCrafterAux;
import com.cout970.magneticraft.util.InventoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;

public class TileCrafter
extends TileBase
implements IInventoryManaged,
IGuiSync,
IGuiListener {
    private InventoryComponent inv = new InventoryComponent(this, 16, "Crafter"){

        @Override
        public void func_70299_a(int slot, ItemStack itemStack) {
            super.func_70299_a(slot, itemStack);
            if (TileCrafter.this.field_145850_b == null || ((TileCrafter)TileCrafter.this).field_145850_b.field_72995_K) {
                return;
            }
            TileCrafter.this.itemMatches = -1;
        }
    };
    private InventoryComponent invResult = new InventoryComponent(this, 1, "Result");
    private InventoryCrafting recipe = new InventoryCrafterAux(this, 3, 3);
    private List<InvSlot> checked = new ArrayList<InvSlot>();
    private int itemMatches = -1;
    private IRecipe craftRecipe;
    private boolean nextCraft = false;
    public RedstoneState state = RedstoneState.NORMAL;

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        if (this.isPowered()) {
            this.nextCraft = true;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.itemMatches == -1) {
            this.refreshItemMatches();
        }
        if (this.isControled()) {
            if (this.craft()) {
                this.refreshItemMatches();
            }
            this.nextCraft = false;
        }
    }

    @Override
    public boolean isControled() {
        if (this.state == RedstoneState.NORMAL) {
            return !this.powered;
        }
        if (this.state == RedstoneState.INVERTED) {
            return this.powered;
        }
        return this.nextCraft;
    }

    public void refreshRecipe() {
        this.craftRecipe = null;
        for (Object rec : CraftingManager.func_77594_a().func_77592_b()) {
            if (!(rec instanceof IRecipe) || !((IRecipe)rec).func_77569_a(this.recipe, this.field_145850_b)) continue;
            this.craftRecipe = (IRecipe)rec;
            break;
        }
        if (this.craftRecipe != null) {
            ItemStack result = this.craftRecipe.func_77572_b(this.recipe);
            if (result == null) {
                this.craftRecipe = null;
            } else {
                this.invResult.func_70299_a(0, result);
            }
        } else {
            this.invResult.func_70299_a(0, null);
        }
    }

    public void refreshItemMatches() {
        this.itemMatches = 0;
        this.checked.clear();
        if (this.craftRecipe == null) {
            this.refreshRecipe();
            if (this.craftRecipe == null) {
                return;
            }
        }
        ItemStack result = this.craftRecipe.func_77572_b(this.recipe);
        block0: for (int slot = 0; slot < 9; ++slot) {
            if (this.recipe.func_70301_a(slot) == null) {
                this.itemMatches |= 1 << slot;
                continue;
            }
            if (this.findItemsFromInventory(slot, this, this.checked, result, MgDirection.UP)) {
                this.itemMatches |= 1 << slot;
                continue;
            }
            for (MgDirection dir : MgDirection.values()) {
                IInventory side;
                TileEntity t = MgUtils.getTileEntity((TileEntity)this, dir);
                if (!(t instanceof IInventory) || !this.findItemsFromInventory(slot, side = (IInventory)t, this.checked, result, dir)) continue;
                this.itemMatches |= 1 << slot;
                continue block0;
            }
        }
    }

    public boolean craft() {
        int slot;
        ItemStack item;
        if (this.itemMatches == 511 && this.craftRecipe != null && (item = this.craftRecipe.func_77572_b(this.recipe)) != null && (slot = InventoryUtils.getSlotForStack(this.getInv(), item)) != -1) {
            for (InvSlot s : this.checked) {
                InventoryUtils.remove(s.inv, s.slot, s.amount, this.getInv());
            }
            if (InventoryUtils.canCombine(this.getInv().func_70301_a(slot), item, 64)) {
                ItemStack result = InventoryUtils.addition(this.getInv().func_70301_a(slot), item);
                this.getInv().func_70299_a(slot, result);
            } else if (!InventoryUtils.dropIntoInventory(item, this.getInv())) {
                BlockMg.dropItem(item, this.func_145831_w().field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145831_w());
            }
            this.checked.clear();
            return true;
        }
        return false;
    }

    private boolean findItemsFromInventory(int slot, IInventory inv, List<InvSlot> visited, ItemStack result, MgDirection dir) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack content = inv.func_70301_a(i);
            if (content == null || !this.canAcces(inv, i, dir) || !this.remplaceMatrix(this.recipe, result, content, slot)) continue;
            InvSlot pos = new InvSlot(content, i, inv);
            if (!visited.contains(pos)) {
                visited.add(pos);
                return true;
            }
            InvSlot ex = visited.get(visited.indexOf(pos));
            if (content.field_77994_a <= ex.amount) continue;
            ++ex.amount;
            return true;
        }
        return false;
    }

    private boolean canAcces(IInventory inv, int slot, MgDirection dir) {
        if (inv instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)inv;
            for (int i : sided.func_94128_d(dir.ordinal())) {
                if (i != slot) continue;
                if (!sided.func_102008_b(slot, sided.func_70301_a(slot), dir.ordinal())) break;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean remplaceMatrix(InventoryCrafting craft, ItemStack result, ItemStack stack, int slot) {
        ItemStack item = craft.func_70301_a(slot);
        craft.func_70299_a(slot, stack);
        boolean ret = false;
        if (this.craftRecipe.func_77569_a(craft, this.field_145850_b)) {
            ItemStack newResult = this.craftRecipe.func_77572_b(craft);
            if (result == null || result.func_77973_b() == null) {
                return false;
            }
            ret = OreDictionary.itemMatches((ItemStack)result, (ItemStack)newResult, (boolean)true);
        }
        craft.func_70299_a(slot, item);
        return ret;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    public InventoryCrafting getRecipe() {
        return this.recipe;
    }

    public InventoryComponent getResult() {
        return this.invResult;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt, "Inv_1");
        InventoryUtils.loadInventory((IInventory)this.recipe, nbt, "Inv_2");
        this.invResult.readFromNBT(nbt, "Inv_3");
        this.itemMatches = nbt.func_74762_e("Matches");
        this.state = RedstoneState.values()[nbt.func_74771_c("State")];
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt, "Inv_1");
        InventoryUtils.saveInventory((IInventory)this.recipe, nbt, "Inv_2");
        this.invResult.writeToNBT(nbt, "Inv_3");
        nbt.func_74768_a("Matches", this.itemMatches);
        nbt.func_74774_a("State", (byte)this.state.ordinal());
    }

    public static RedstoneState step(RedstoneState state) {
        return state == RedstoneState.NORMAL ? RedstoneState.INVERTED : (state == RedstoneState.INVERTED ? RedstoneState.PULSE : RedstoneState.NORMAL);
    }

    public void setRedstoneState(RedstoneState e) {
        this.state = e;
        this.sendUpdateToClient();
    }

    public boolean found(int j) {
        if (this.itemMatches == -1) {
            return false;
        }
        return this.craftRecipe == null || (this.itemMatches & 1 << j) > 0;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, this.itemMatches);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.itemMatches = value;
        }
    }

    @Override
    public void onMessageReceive(int id, int value) {
        if (id == 0) {
            if (value == 1) {
                for (int i = 0; i < 9; ++i) {
                    this.getRecipe().func_70299_a(i, null);
                }
                this.refreshRecipe();
            } else if (value == 0) {
                this.nextCraft = true;
            }
        }
    }

    public static enum RedstoneState {
        NORMAL,
        INVERTED,
        PULSE;

    }

    public class InvSlot {
        public ItemStack content;
        public int amount;
        public int slot;
        public IInventory inv;

        public InvSlot(ItemStack stack, int slot, IInventory inv) {
            this.inv = inv;
            this.slot = slot;
            this.inv = inv;
            this.amount = 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof InvSlot) {
                InvSlot pos = (InvSlot)obj;
                return pos.slot == this.slot && pos.inv == this.inv && InventoryUtils.areExaticlyEqual(this.content, pos.content);
            }
            return false;
        }
    }
}

