/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.acces.RecipeCrusher;
import com.cout970.magneticraft.api.electricity.BufferedConductor;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.tileentity.TileMB_Base;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.InventoryUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileCrusher
extends TileMB_Base
implements IGuiSync,
IInventoryManaged,
ISidedInventory {
    private float MAX_PROGRESS = 100.0f;
    public float animation;
    public boolean auto;
    public float progress = 0.0f;
    public int maxProgres = 100;
    public BufferedConductor cond = new BufferedConductor(this, 0.01, 160000, 140.0, 160.0);
    private double flow;
    private InventoryComponent inv = new InventoryComponent(this, 4, "Crusher");
    private InventoryComponent in;
    private InventoryComponent out;
    private float speed = 0.0f;
    public int drawCounter;
    private long time;
    public boolean working;

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.sendUpdateToClient();
        }
        this.updateConductor();
        if (this.cond.getVoltage() >= 120.0) {
            this.speed = (float)this.cond.getStorage() * 10.0f / (float)this.cond.getMaxStorage();
            if (this.canCraft()) {
                this.working = true;
                if (this.speed > 0.0f) {
                    this.progress += this.speed;
                    this.cond.drainPower(EnergyConversor.RFtoW(this.speed * 10.0f));
                    if (this.progress >= this.MAX_PROGRESS) {
                        this.craft();
                        this.func_70296_d();
                        this.progress %= this.MAX_PROGRESS;
                    }
                } else {
                    this.working = false;
                }
            } else {
                this.working = false;
                this.progress = 0.0f;
            }
        } else {
            this.working = false;
        }
        this.distributeItems();
    }

    private void distributeItems() {
        TileEntity c;
        VecInt v;
        MgDirection d;
        if (this.in == null) {
            if (this.func_145832_p() % 8 >= 4) {
                d = this.getDirection().opposite();
                v = d.toVecInt().multiply(2).add(d.step(MgDirection.UP).toVecInt().getOpposite());
                c = MgUtils.getTileEntity((TileEntity)this, v);
                if (c instanceof IInventoryManaged) {
                    this.in = ((IInventoryManaged)c).getInv();
                }
            } else {
                d = this.getDirection().opposite();
                v = d.toVecInt().multiply(2).add(d.step(MgDirection.DOWN).toVecInt().getOpposite());
                c = MgUtils.getTileEntity((TileEntity)this, v);
                if (c instanceof IInventoryManaged) {
                    this.in = ((IInventoryManaged)c).getInv();
                }
            }
        }
        if (this.out == null) {
            if (this.func_145832_p() % 8 < 4) {
                d = this.getDirection().opposite();
                v = d.toVecInt().multiply(2).add(d.step(MgDirection.UP).toVecInt().multiply(3).getOpposite());
                c = MgUtils.getTileEntity((TileEntity)this, v);
                if (c instanceof IInventoryManaged) {
                    this.out = ((IInventoryManaged)c).getInv();
                }
            } else {
                d = this.getDirection().opposite();
                v = d.toVecInt().multiply(2).add(d.step(MgDirection.DOWN).toVecInt().multiply(3).getOpposite());
                c = MgUtils.getTileEntity((TileEntity)this, v);
                if (c instanceof IInventoryManaged) {
                    this.out = ((IInventoryManaged)c).getInv();
                }
            }
        }
        if (this.in != null && this.out != null) {
            if (((TileBase)this.in.tile).isControled()) {
                if (this.getInv().func_70301_a(0) != null) {
                    int s = InventoryUtils.findCombination(this.in, this.getInv().func_70301_a(0));
                    if (s != -1) {
                        InventoryUtils.traspass(this.in, this, s, 0);
                    }
                } else {
                    this.func_70299_a(0, InventoryUtils.getItemStack(this.in));
                }
            }
            if (((TileBase)this.out.tile).isControled()) {
                for (int i = 0; i < 3; ++i) {
                    int s;
                    if (this.getInv().func_70301_a(i + 1) == null || (s = InventoryUtils.getSlotForStack(this.out, this.getInv().func_70301_a(i + 1))) == -1) continue;
                    InventoryUtils.traspass(this, this.out, i + 1, s);
                }
            }
        }
    }

    @Override
    public MgDirection getDirection() {
        int meta = this.func_145832_p();
        return MgDirection.getDirection(meta % 4 + 2);
    }

    private void craft() {
        int i;
        ItemStack a = this.getInv().func_70301_a(0);
        RecipeCrusher r = RecipeCrusher.getRecipe(a);
        this.getInv().func_70299_a(1, InventoryUtils.addition(r.getOutput(), this.getInv().func_70301_a(1)));
        int intents = (int)r.getProb2() + 1;
        for (i = 0; i < intents; ++i) {
            if (!(this.field_145850_b.field_73012_v.nextFloat() <= r.getProb2() - (float)i)) continue;
            this.getInv().func_70299_a(2, InventoryUtils.addition(r.getOutput2(), this.getInv().func_70301_a(2)));
        }
        intents = (int)r.getProb3() + 1;
        for (i = 0; i < intents; ++i) {
            if (!(this.field_145850_b.field_73012_v.nextFloat() <= r.getProb3() - (float)i)) continue;
            this.getInv().func_70299_a(3, InventoryUtils.addition(r.getOutput3(), this.getInv().func_70301_a(3)));
        }
        --a.field_77994_a;
        if (a.field_77994_a <= 0) {
            this.getInv().func_70299_a(0, null);
        }
    }

    private boolean canCraft() {
        ItemStack a = this.getInv().func_70301_a(0);
        if (a == null) {
            return false;
        }
        RecipeCrusher r = RecipeCrusher.getRecipe(a);
        if (r == null) {
            return false;
        }
        if (this.getInv().func_70301_a(1) != null && !InventoryUtils.canCombine(r.getOutput(), this.getInv().func_70301_a(1), this.getInv().func_70297_j_())) {
            return false;
        }
        if (this.getInv().func_70301_a(2) != null && !InventoryUtils.canCombine(r.getOutput2(), this.getInv().func_70301_a(2), this.getInv().func_70297_j_())) {
            return false;
        }
        return this.getInv().func_70301_a(3) == null || InventoryUtils.canCombine(r.getOutput3(), this.getInv().func_70301_a(3), this.getInv().func_70297_j_());
    }

    public void updateConductor() {
        this.cond.recache();
        this.cond.iterate();
        MgDirection d = this.getDirection().opposite();
        TileEntity c = MgUtils.getTileEntity((TileEntity)this, d.toVecInt().multiply(3));
        if (c instanceof IElectricTile) {
            CompoundElectricCables comp = ((IElectricTile)c).getConds(VecInt.NULL_VECTOR, 0);
            IElectricConductor cond2 = comp.getCond(0);
            double resistence = this.cond.getResistance() + cond2.getResistance();
            double difference = this.cond.getVoltage() - cond2.getVoltage();
            double change = this.flow;
            double slow = change * resistence;
            this.flow += (difference - slow) * this.cond.getIndScale() / this.cond.getVoltageMultiplier();
            this.cond.applyCurrent(-(change += difference * this.cond.getCondParallel() / this.cond.getVoltageMultiplier()));
            cond2.applyCurrent(change);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.working = nbt.func_74767_n("W");
        this.cond.load(nbt);
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("W", this.working);
        this.cond.save(nbt);
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage());
        craft.func_71112_a(cont, 2, (int)this.progress);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.cond.setStorage(value);
        }
        if (id == 2) {
            this.progress = value;
        }
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.cond.disconect();
        this.in = null;
        this.out = null;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    public IBarProvider getProgresBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return TileCrusher.this.MAX_PROGRESS;
            }

            @Override
            public float getLevel() {
                return TileCrusher.this.progress;
            }
        };
    }

    public boolean isActive() {
        return this.func_145832_p() >= 8;
    }
}

