/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ConnectionClass;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.ElectricConstants;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IEnergyInterface;
import com.cout970.magneticraft.api.electricity.IndexedConnection;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileDiode
extends TileConductorLow {
    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this, 5.0){

            @Override
            public void recache() {
                if (!this.connected) {
                    this.connected = true;
                    this.con.clear();
                    int sides = 0;
                    for (VecInt f : this.getValidConnections()) {
                        TileEntity target = MgUtils.getTileEntity(this.tile, f);
                        CompoundElectricCables c = MgUtils.getElectricCond(target, f.getOpposite(), this.getTier());
                        IEnergyInterface inter = MgUtils.getInterface(target, f.getOpposite(), this.getTier());
                        if (c != null) {
                            for (IElectricConductor e : c.list()) {
                                if (e == this || !this.isAbleToConnect(e, f) || !e.isAbleToConnect(this, f.getOpposite())) continue;
                                this.con.add(new IndexedConnection((IElectricConductor)this, f, e, sides));
                                ++sides;
                            }
                        }
                        if (inter == null || !inter.canConnect(f)) continue;
                        this.con.add(new IndexedConnection((IElectricConductor)this, f, inter, sides));
                        ++sides;
                    }
                    if (this.currents == null) {
                        this.currents = new double[sides];
                    } else if (this.currents.length != sides) {
                        double[] temp = new double[sides];
                        for (int i = 0; i < Math.min(sides, this.currents.length); ++i) {
                            temp[i] = this.currents[i];
                        }
                        this.currents = temp;
                    }
                }
            }

            @Override
            public void iterate() {
                TileEntity tile = this.getParent();
                World w = tile.func_145831_w();
                if (w.field_72995_K) {
                    return;
                }
                tile.func_70296_d();
                this.getVoltage();
                for (IndexedConnection f : this.con) {
                    double watt;
                    IElectricConductor cond = f.cond;
                    IEnergyInterface c = f.inter;
                    if (cond != null && cond.canFlowPower(f)) {
                        double resistence = this.getResistance() + cond.getResistance();
                        double deltaV = this.V - cond.getVoltage();
                        if (Double.isNaN(this.currents[f.index])) {
                            this.currents[f.index] = 0.0;
                        }
                        double current = this.currents[f.index];
                        double vDiff = deltaV - current * resistence;
                        vDiff = Math.min(vDiff, Math.abs(deltaV));
                        vDiff = Math.max(vDiff, -Math.abs(deltaV));
                        int n = f.index;
                        this.currents[n] = this.currents[n] + vDiff * this.getIndScale() / this.getVoltageMultiplier();
                        current += deltaV * this.getCondParallel() / this.getVoltageMultiplier();
                        if (TileDiode.this.getDirection().toVecInt().equals(f.vecDir)) {
                            if (deltaV > 0.5) {
                                this.applyCurrent(-current);
                                cond.applyCurrent(current);
                            }
                        } else {
                            this.applyCurrent(-current);
                            cond.applyCurrent(current);
                        }
                    }
                    if (c == null || !(this.V > 120.0) || !c.canAcceptEnergy(f) || !((watt = Math.min(c.getMaxFlow(), (this.V - 120.0) * ElectricConstants.CONVERSION_SPEED)) > 0.0)) continue;
                    this.drainPower(c.applyEnergy(watt));
                }
            }

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileDiode.this.getDirection().toVecInt(), TileDiode.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public boolean canFlowPower(IndexedConnection con) {
                return con.source.getClass().isAssignableFrom(this.getClass());
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_LOW;
            }
        };
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int tier) {
        if (tier != 0 && tier != -1) {
            return null;
        }
        if (dir == VecInt.NULL_VECTOR || this.getDirection().toVecInt().equals(dir) || this.getDirection().opposite().toVecInt().equals(dir)) {
            return new CompoundElectricCables(this.cond);
        }
        return null;
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }
}

