/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.Info;
import ic2.api.tile.IEnergyStorage;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEUAlternator
extends TileConductorLow
implements IEnergySink,
IEnergyStorage {
    public int storage = 0;
    public int maxStorage = 32000;
    public double min = 240.0;
    private boolean addedToEnet;

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this){

            @Override
            public void iterate() {
                super.iterate();
                if (!TileEUAlternator.this.isControled()) {
                    return;
                }
                if (this.getVoltage() < TileEUAlternator.this.min && TileEUAlternator.this.storage > 0) {
                    int change = (int)Math.min((TileEUAlternator.this.min - this.getVoltage()) * 80.0, 512.0);
                    change = Math.min(change, TileEUAlternator.this.storage);
                    this.applyPower(EnergyConversor.EUtoW(change));
                    TileEUAlternator.this.storage -= change;
                }
            }

            @Override
            public int getStorage() {
                return TileEUAlternator.this.storage;
            }

            @Override
            public int getMaxStorage() {
                return TileEUAlternator.this.maxStorage;
            }

            @Override
            public void setStorage(int charge) {
                TileEUAlternator.this.storage = charge;
            }

            @Override
            public void applyCharge(int charge) {
                TileEUAlternator.this.storage += charge;
                if (TileEUAlternator.this.storage > TileEUAlternator.this.maxStorage) {
                    TileEUAlternator.this.storage = TileEUAlternator.this.maxStorage;
                }
            }

            @Override
            public void drainCharge(int charge) {
                TileEUAlternator.this.storage -= charge;
                if (TileEUAlternator.this.storage < 0) {
                    TileEUAlternator.this.storage = 0;
                }
            }

            @Override
            public void save(NBTTagCompound nbt) {
                super.save(nbt);
                nbt.func_74768_a("Storage", TileEUAlternator.this.storage);
            }

            @Override
            public void load(NBTTagCompound nbt) {
                super.load(nbt);
                TileEUAlternator.this.storage = nbt.func_74762_e("Storage");
            }

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileEUAlternator.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public boolean isAbleToConnect(IElectricConductor c, VecInt d) {
                return TileEUAlternator.this.getDirection().opposite().toVecInt().equals(d);
            }
        };
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return direction == this.getDirection().toForgeDir();
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxStorage - this.storage;
    }

    @Override
    public int getSinkTier() {
        return 2;
    }

    @Override
    public double injectEnergy(ForgeDirection dir, double amount, double voltage) {
        if (dir == this.getDirection().toForgeDir()) {
            double move = Math.min(amount, (double)(this.maxStorage - this.storage));
            this.storage = (int)((double)this.storage + move);
            return amount - move;
        }
        return amount;
    }

    @Override
    public int getStored() {
        return this.storage;
    }

    @Override
    public void setStored(int energy) {
        this.storage = energy;
    }

    @Override
    public int addEnergy(int amount) {
        this.storage += amount;
        return this.storage;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return 0;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return 0.0;
    }

    @Override
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return false;
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }
}

