/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.wires.ElectricPoleTier1;
import com.cout970.magneticraft.api.electricity.wires.IElectricPole;
import com.cout970.magneticraft.api.electricity.wires.ITileElectricPole;
import com.cout970.magneticraft.api.electricity.wires.WireConnection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.tileentity.TileElectricPoleCableWireDown;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileElectricPoleCableWire
extends TileConductorLow
implements ITileElectricPole {
    public ElectricPoleTier1 pole;
    private double flow;
    public boolean clientUpdate = false;
    public boolean updateCables = true;
    public boolean locked = false;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onBlockBreaks() {
        this.pole.disconectAll();
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.updateCables = true;
    }

    @Override
    public void func_145845_h() {
        CompoundElectricCables comp;
        super.func_145845_h();
        if (this.updateCables && !this.locked) {
            this.findConnections();
            this.updateCables = false;
        }
        this.pole.iterate();
        TileElectricPoleCableWireDown t = this.getBase();
        if (t != null && (comp = t.getConds(VecInt.NULL_VECTOR, 0)) != null) {
            IElectricConductor to = comp.getCond(0);
            double resistence = to.getResistance() + this.cond.getResistance();
            double deltaV = to.getVoltage() - this.cond.getVoltage();
            if (Double.isNaN(this.flow)) {
                this.flow = 0.0;
            }
            double current = this.flow;
            double vDiff = deltaV - current * resistence;
            vDiff = Math.min(vDiff, Math.abs(deltaV));
            vDiff = Math.max(vDiff, -Math.abs(deltaV));
            this.flow += vDiff * to.getIndScale() / to.getVoltageMultiplier();
            to.applyCurrent(-(current += deltaV * to.getCondParallel() / to.getVoltageMultiplier()));
            this.cond.applyCurrent(current);
        }
        if (this.clientUpdate) {
            this.clientUpdate = false;
            this.sendUpdateToClient();
        }
    }

    public void findConnections() {
        ElectricPoleTier1.findConnections(this.pole);
        this.clientUpdate = true;
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int Vtier) {
        if (dir == VecInt.NULL_VECTOR && Vtier == 0) {
            return new CompoundElectricCables(this.cond);
        }
        return null;
    }

    @Override
    public IElectricPole getPoleConnection() {
        return this.pole;
    }

    @Override
    public ITileElectricPole getMainTile() {
        return this;
    }

    @Override
    public IElectricConductor initConductor() {
        this.cond = new ElectricConductor(this);
        this.pole = new ElectricPoleTier1(this, this.cond){

            @Override
            public void onDisconnect(WireConnection conn) {
                super.onDisconnect(conn);
                TileElectricPoleCableWire.this.clientUpdate = true;
            }
        };
        return this.cond;
    }

    public TileElectricPoleCableWireDown getBase() {
        VecInt vec = new VecInt(0, -4, 0);
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileElectricPoleCableWireDown) {
            return (TileElectricPoleCableWireDown)t;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.flow = nbt.func_74769_h("energyFlow");
        this.pole.load(nbt);
        this.locked = nbt.func_74767_n("Locked");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("energyFlow", this.flow);
        this.pole.save(nbt);
        nbt.func_74757_a("Locked", this.locked);
    }
}

