/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.InventoryUtils;
import com.cout970.magneticraft.util.fluid.TankConection;
import com.cout970.magneticraft.util.fluid.TankMg;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileFluidHopper
extends TileBase
implements IFluidHandler1_8,
IGuiSync,
ISidedInventory {
    public TankMg tank = new TankMg(this, 5000);
    public ItemStack[] inventory = new ItemStack[2];

    @Override
    public void func_145845_h() {
        TileEntity t;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.inventory[0] != null) {
            ItemStack h;
            FluidStack f;
            if (this.tank.getSpace() >= 1000 && (f = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.inventory[0])) != null) {
                ItemStack i = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                if ((this.inventory[1] == null || InventoryUtils.canCombine(i, this.inventory[1], 64)) && this.tank.fill(f, false) == f.amount) {
                    this.inventory[1] = InventoryUtils.addition(i, this.inventory[1]);
                    this.inventory[0].func_77979_a(1);
                    if (this.inventory[0].field_77994_a <= 0) {
                        this.inventory[0] = null;
                    }
                    this.tank.fill(f, true);
                }
            }
            if (this.tank.getFluidAmount() >= 1000 && FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[0]) && (h = FluidContainerRegistry.fillFluidContainer((FluidStack)this.tank.drain(1000, false), (ItemStack)this.inventory[0])) != null && (this.inventory[1] == null || InventoryUtils.canCombine(h, this.inventory[1], 64))) {
                this.inventory[1] = InventoryUtils.addition(h, this.inventory[1]);
                this.inventory[0].func_77979_a(1);
                if (this.inventory[0].field_77994_a <= 0) {
                    this.inventory[0] = null;
                }
                this.tank.drain(1000, true);
            }
        }
        if (this.tank.getSpace() >= 1000) {
            t = MgUtils.getTileEntity((TileEntity)this, MgDirection.UP);
            if (t instanceof IFluidHandler) {
                FluidTankInfo[] info;
                TankConection tan = new TankConection((IFluidHandler)t, MgDirection.DOWN);
                for (FluidTankInfo i : info = tan.getTankInfo(MgDirection.DOWN)) {
                    FluidStack fl;
                    if (i.fluid == null || this.tank.getFluid() != null && !i.fluid.isFluidEqual(this.tank.getFluid()) || (fl = tan.drain(MgDirection.DOWN, 100, false)) == null) continue;
                    int h = this.tank.fill(fl, true);
                    tan.drain(MgDirection.DOWN, h, true);
                    break;
                }
            } else if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                Fluid f;
                Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                if (this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == 0 && (f = FluidRegistry.lookupFluidForBlock((Block)b)) != null) {
                    this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
                    FluidStack resource = new FluidStack(f, 1000);
                    this.tank.fill(resource, true);
                }
            }
        }
        if (this.tank.getFluidAmount() == 0) {
            return;
        }
        t = MgUtils.getTileEntity((TileEntity)this, MgDirection.getDirection(this.func_145832_p()));
        if (t instanceof IFluidHandler) {
            IFluidHandler f = (IFluidHandler)t;
            FluidTankInfo[] infos = f.getTankInfo(ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite());
            for (FluidTankInfo info : infos) {
                if (info == null) continue;
                int amount = info.fluid == null ? 0 : info.fluid.amount;
                int change = Math.min(this.tank.getFluidAmount(), info.capacity - amount);
                if ((change = Math.min(change, 50)) <= 0) continue;
                FluidStack resource = this.tank.drain(change, false);
                int filled = f.fill(ForgeDirection.getOrientation((int)this.func_145832_p()).getOpposite(), resource, true);
                this.tank.drain(filled, true);
            }
        }
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        if (from != MgDirection.getDirection(this.func_145832_p())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        if (this.tank.getFluidAmount() > 0) {
            craft.func_71112_a(cont, 0, this.tank.getFluid().getFluidID());
        }
        craft.func_71112_a(cont, 1, this.tank.getFluidAmount());
    }

    @Override
    public void getGUINetworkData(int i, int value) {
        if (i == 0) {
            this.tank.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
        }
        if (i == 1) {
            if (value == 0) {
                this.tank.setFluid(null);
            } else {
                this.tank.setFluid(new FluidStack(this.tank.getFluid(), value));
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.inventory[var1];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory[var1];
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        this.inventory[slot] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "Fluid Hopper";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.tank.readFromNBT(nbtTagCompound, "fluid");
        NBTTagList tagList = nbtTagCompound.func_150295_c("Inventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tagCompound = tagList.func_150305_b(i);
            byte slot = tagCompound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.length) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.tank.writeToNBT(nbtTagCompound, "fluid");
        NBTTagList list = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)currentIndex);
            this.inventory[currentIndex].func_77955_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        nbtTagCompound.func_74782_a("Inventory", (NBTBase)list);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack i, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack i, int side) {
        return slot == 1;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this instanceof IFluidHandler1_8) {
            return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this instanceof IFluidHandler1_8) {
            return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
        }
        return null;
    }
}

