/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.heat.CompoundHeatCables;
import com.cout970.magneticraft.api.heat.HeatConductor;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.IHeatTile;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileMB_Base;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;

public class TileHeater
extends TileMB_Base
implements IHeatTile,
IGuiSync,
IElectricTile {
    public IHeatConductor heat = new HeatConductor(this, 1400.0, 1000.0);
    public IElectricConductor cond = this.initConductor();
    public static int MaxProduction = 120;
    public int oldHeat;
    private boolean working;

    public IElectricConductor initConductor() {
        return new ElectricConductor(this);
    }

    @Override
    public CompoundHeatCables getHeatCond(VecInt c) {
        return new CompoundHeatCables(this.heat);
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.cond.disconect();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            double i;
            this.cond.recache();
            this.cond.iterate();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                if (this.working && !this.isActive()) {
                    this.setActive(true);
                } else if (!this.working && this.isActive()) {
                    this.setActive(false);
                }
            }
            this.heat.iterate();
            if ((int)this.heat.getTemperature() != this.oldHeat && this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
                this.sendUpdateToClient();
                this.oldHeat = (int)this.heat.getTemperature();
            }
            if ((i = EnergyConversor.RFtoCALORIES(this.getComsumption())) > 0.0) {
                this.cond.drainPower(EnergyConversor.CALORIEStoW(i));
                this.heat.applyCalories(i);
                this.working = true;
            } else {
                this.working = false;
            }
        }
    }

    private void setActive(boolean b) {
        if (this.func_145832_p() != 2) {
            if (b) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, 2);
            } else {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
            }
        }
    }

    public boolean isActive() {
        return this.func_145832_p() == 1;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heat.load(nbt);
        this.cond.load(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.heat.save(nbt);
        this.cond.save(nbt);
    }

    public int getComsumption() {
        if (this.cond.getVoltage() > 120.0 && this.heat.getTemperature() < 1200.0) {
            return (int)((double)MaxProduction * (this.cond.getVoltage() / 240.0));
        }
        return 0;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 10, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 11, (int)this.heat.getTemperature());
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 10) {
            this.cond.setVoltage(value);
        }
        if (id == 11) {
            this.heat.setTemperature(value);
        }
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int tier) {
        if (tier != 0) {
            return null;
        }
        return new CompoundElectricCables(this.cond);
    }
}

