/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.conveyor.ConveyorSide;
import com.cout970.magneticraft.api.conveyor.IConveyor;
import com.cout970.magneticraft.api.conveyor.ItemBox;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.MgBeltUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.oredict.OreDictionary;

public class TileInserter
extends TileBase
implements IGuiListener {
    public InventoryComponent inv = new InventoryComponent(this, 1, "Inserter");
    public InventoryComponent filter = new InventoryComponent(this, 9, "Filter");
    public boolean whiteList;
    public boolean ignoreNBT;
    public boolean ignoreMeta;
    public boolean ignoreDict;
    public byte valid_dirs = (byte)15;
    public int counter = 0;
    public InserterAnimation anim = null;
    public int speed = 20;

    public MgDirection getDir() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    @Override
    public void onBlockBreaks() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockMg.dropItem(this.getInv().func_70301_a(0), this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.anim == InserterAnimation.Retracting_Short || this.anim == InserterAnimation.Retracting_Large) {
            if (this.counter >= 180) {
                this.anim = InserterAnimation.Rotating;
                this.counter = 0;
                this.sendUpdateToClient();
            } else {
                this.counter += this.speed;
            }
        } else if (this.anim == InserterAnimation.Retracting_INV_Short || this.anim == InserterAnimation.Retracting_INV_Large) {
            if (this.counter >= 180) {
                this.anim = InserterAnimation.Rotating_INV;
                this.counter = 0;
                this.sendUpdateToClient();
            } else {
                this.counter += this.speed;
            }
        } else if (this.anim == InserterAnimation.Rotating) {
            if (this.counter >= 180) {
                TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
                this.anim = o instanceof IConveyor && ((IConveyor)o).getOrientation().getLevel() == 0 && ((IConveyor)o).getDir().isPerpendicular(this.getDir()) ? InserterAnimation.Extending_INV_Large : InserterAnimation.Extending_INV_Short;
                this.counter = 0;
                this.sendUpdateToClient();
            } else {
                this.counter += this.speed;
            }
        } else if (this.anim == InserterAnimation.Rotating_INV) {
            if (this.counter >= 180) {
                this.anim = InserterAnimation.Extending_Short;
                this.counter = 0;
                this.sendUpdateToClient();
            } else {
                this.counter += this.speed;
            }
        } else if (this.getInv().func_70301_a(0) != null) {
            if (this.counter >= 180 && (this.anim == InserterAnimation.Extending_INV_Short || this.anim == InserterAnimation.Extending_INV_Large)) {
                TileEntity t = MgUtils.getTileEntity((TileEntity)this, this.getDir());
                TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
                if (o instanceof IInventory) {
                    this.dropToInv((IInventory)o);
                } else if (o instanceof IConveyor && ((IConveyor)o).getOrientation().getLevel() == 0) {
                    this.dropToBelt((IConveyor)o);
                } else if (this.canDropItems() && this.field_145850_b.func_82737_E() % 10L == 0L) {
                    this.dropItem();
                }
                if (this.getInv().func_70301_a(0) == null) {
                    this.anim = this.anim == InserterAnimation.Extending_INV_Short ? InserterAnimation.Retracting_INV_Short : InserterAnimation.Retracting_INV_Large;
                    this.counter = 0;
                }
                this.sendUpdateToClient();
            } else {
                this.counter += this.speed;
                if (this.anim != InserterAnimation.Extending_INV_Short && this.anim != InserterAnimation.Extending_INV_Large) {
                    this.anim = InserterAnimation.Extending_INV_Short;
                    this.sendUpdateToClient();
                }
            }
        } else if (this.getInv().func_70301_a(0) == null) {
            if (this.counter >= 180 && (this.anim == InserterAnimation.Extending_Short || this.anim == InserterAnimation.Extending_Large)) {
                if (this.isControled()) {
                    TileEntity t = MgUtils.getTileEntity((TileEntity)this, this.getDir());
                    TileEntity o = MgUtils.getTileEntity((TileEntity)this, this.getDir().opposite());
                    if (t instanceof IInventory) {
                        this.suckFromInv((IInventory)t, o);
                    } else if (t instanceof IConveyor && ((IConveyor)t).getOrientation().getLevel() == 0) {
                        this.suckFromBelt((IConveyor)t, o);
                    }
                    if (this.getInv().func_70301_a(0) != null) {
                        this.anim = this.anim == InserterAnimation.Extending_Short ? InserterAnimation.Retracting_Short : InserterAnimation.Retracting_Large;
                        this.counter = 0;
                        this.sendUpdateToClient();
                    }
                }
            } else {
                this.counter += this.speed;
                if (this.anim != InserterAnimation.Extending_Short || this.anim != InserterAnimation.Extending_Large) {
                    this.anim = InserterAnimation.Extending_Short;
                    this.sendUpdateToClient();
                }
            }
        } else {
            this.anim = InserterAnimation.Extending_Short;
            this.counter = 0;
        }
    }

    private void dropItem() {
        List l;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        VecInt vec1 = new VecInt(this).add(this.getDir().opposite().toVecInt());
        Block b = this.field_145850_b.func_147439_a(vec1.getX(), vec1.getY(), vec1.getZ());
        if (Block.func_149680_a((Block)Blocks.field_150350_a, (Block)b) && (l = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)vec1.getX(), (double)vec1.getY(), (double)vec1.getZ(), (double)(vec1.getX() + 1), (double)(vec1.getY() + 1), (double)(vec1.getZ() + 1)))).isEmpty()) {
            ItemStack item = this.getInv().func_70301_a(0);
            if (item == null) {
                return;
            }
            VecDouble vec2 = new VecDouble(vec1);
            vec2.add(0.5, 0.5, 0.5);
            EntityItem entityItem = new EntityItem(this.field_145850_b, vec2.getX(), vec2.getY(), vec2.getZ(), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            this.field_145850_b.func_72838_d((Entity)entityItem);
            this.getInv().func_70299_a(0, null);
        }
    }

    private boolean canDropItems() {
        return false;
    }

    private void dropToBelt(IConveyor t) {
        ItemStack s = this.getInv().func_70301_a(0);
        if (t.addItem(this.getDir(), 2, new ItemBox(s), true)) {
            this.getInv().func_70299_a(0, null);
            t.addItem(this.getDir(), 2, new ItemBox(s), false);
        }
    }

    private void dropToInv(IInventory t) {
        ItemStack s = this.getInv().func_70301_a(0);
        if (MgBeltUtils.dropItemStackIntoInventory(t, s, MgDirection.UP, true) == 0) {
            this.getInv().func_70299_a(0, null);
            MgBeltUtils.dropItemStackIntoInventory(t, s, MgDirection.UP, false);
        }
    }

    private void suckFromBelt(IConveyor t, Object obj) {
        ConveyorSide side = t.getSideLane(true);
        if (this.extractFromBelt(side, t, true, obj)) {
            return;
        }
        side = t.getSideLane(false);
        if (this.extractFromBelt(side, t, false, obj)) {
            return;
        }
    }

    public boolean extractFromBelt(ConveyorSide side, IConveyor t, boolean left, Object obj) {
        if (side.content.isEmpty()) {
            return false;
        }
        ItemBox b = side.content.get(0);
        if (t.removeItem(b, left, true) && this.canInject(obj, b.getContent()) && this.canExtract(t, b.getContent())) {
            t.removeItem(b, left, false);
            this.getInv().func_70299_a(0, b.getContent());
            return true;
        }
        return false;
    }

    private void suckFromInv(IInventory t, Object obj) {
        ItemStack s;
        int slot = this.getSlotWithItemStack(t);
        if (slot != -1 && this.canInject(obj, s = t.func_70301_a(slot)) && this.canExtract(t, s)) {
            this.getInv().func_70299_a(0, s);
            t.func_70299_a(slot, null);
        }
    }

    public boolean canExtract(Object obj, ItemStack s) {
        if (s == null) {
            return false;
        }
        if (this.whiteList) {
            for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
                if (!this.checkFilter(i, s)) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < this.filter.func_70302_i_(); ++i) {
            if (!this.checkFilter(i, s)) continue;
            return false;
        }
        return true;
    }

    public int getSlotWithItemStack(IInventory i) {
        for (MgDirection d : this.getValidDirections()) {
            int s = MgBeltUtils.getSlotWithItemStack(i, d);
            if (s == -1) continue;
            return s;
        }
        return -1;
    }

    private List<MgDirection> getValidDirections() {
        ArrayList<MgDirection> list = new ArrayList<MgDirection>();
        for (MgDirection d : MgDirection.values()) {
            if ((this.valid_dirs & 1 << d.ordinal()) <= 0) continue;
            list.add(d);
        }
        return list;
    }

    public boolean checkFilter(int slot, ItemStack i) {
        ItemStack f = this.filter.func_70301_a(slot);
        if (f == null) {
            return false;
        }
        if (!this.ignoreDict) {
            int[] c = OreDictionary.getOreIDs((ItemStack)i);
            int[] d = OreDictionary.getOreIDs((ItemStack)f);
            if (c.length > 0 && d.length > 0) {
                for (int k : c) {
                    for (int j : d) {
                        if (k != j) continue;
                        return true;
                    }
                }
            }
        }
        if (f.func_77973_b() != i.func_77973_b()) {
            return false;
        }
        if (!this.ignoreMeta && f.func_77960_j() != i.func_77960_j()) {
            return false;
        }
        return this.ignoreNBT || f.func_77978_p() == i.func_77978_p();
    }

    public boolean canInject(Object obj, ItemStack s) {
        if (obj instanceof IInventory) {
            return MgBeltUtils.dropItemStackIntoInventory((IInventory)obj, s, MgDirection.UP, true) == 0;
        }
        if (obj instanceof IConveyor) {
            return ((IConveyor)obj).addItem(this.getDir(), 2, new ItemBox(s), true);
        }
        return this.canDropItems();
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.getInv().readFromNBT(nbt);
        this.counter = nbt.func_74762_e("Stage");
        this.anim = InserterAnimation.values()[nbt.func_74762_e("Animation") % InserterAnimation.values().length];
        this.whiteList = nbt.func_74767_n("WhiteList");
        this.ignoreMeta = nbt.func_74767_n("IgnoreMeta");
        this.ignoreNBT = nbt.func_74767_n("IgnoreNBT");
        this.ignoreDict = nbt.func_74767_n("IgnoreDict");
        this.valid_dirs = nbt.func_74771_c("ValidDirs");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.getInv().writeToNBT(nbt);
        nbt.func_74768_a("Stage", this.counter);
        nbt.func_74768_a("Animation", this.anim == null ? 0 : this.anim.ordinal());
        nbt.func_74757_a("WhiteList", this.whiteList);
        nbt.func_74757_a("IgnoreMeta", this.ignoreMeta);
        nbt.func_74757_a("IgnoreNBT", this.ignoreNBT);
        nbt.func_74757_a("IgnoreDict", this.ignoreDict);
        nbt.func_74774_a("ValidDirs", this.valid_dirs);
    }

    @Override
    public void onMessageReceive(int id, int dato) {
        if (id == 0) {
            this.whiteList = dato == 1;
            this.sendUpdateToClient();
        } else if (id == 1) {
            this.ignoreMeta = dato == 1;
            this.sendUpdateToClient();
        } else if (id == 2) {
            this.ignoreNBT = dato == 1;
            this.sendUpdateToClient();
        } else if (id == 3) {
            this.ignoreDict = dato == 1;
            this.sendUpdateToClient();
        }
    }

    public static enum InserterAnimation {
        Default,
        Rotating,
        Rotating_INV,
        Retracting_Short,
        Extending_Short,
        Retracting_INV_Short,
        Extending_INV_Short,
        Retracting_Large,
        Extending_Large,
        Retracting_INV_Large,
        Extending_INV_Large;

    }
}

