/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IEnergyTracker;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.util.tile.TileConductorMedium;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileKineticGenerator
extends TileConductorMedium
implements IEnergyHandler,
IGuiSync {
    protected EnergyStorage storage = new EnergyStorage(32000);
    public float rotation = 0.0f;
    private long time;
    private int lastProd = 0;
    private int prodCount = 0;
    private int prodLastSec = 0;
    private boolean working;

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this, 2, 0.05){

            @Override
            public double getInvCapacity() {
                return EnergyConversor.RFtoW(1.0);
            }
        };
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int tier) {
        if (tier != 2) {
            return null;
        }
        if (VecInt.NULL_VECTOR == dir) {
            return new CompoundElectricCables(this.cond);
        }
        if (dir.toMgDirection() == this.getDirection().opposite()) {
            return new CompoundElectricCables(this.cond);
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        IEnergyReceiver e;
        TileEntity t;
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.lastProd = 0;
        if (this.cond.getVoltage() > 12000.0 && this.isControled()) {
            float f = (float)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) * 10.0f / (float)this.storage.getMaxEnergyStored();
            int min = (int)Math.min((this.cond.getVoltage() - 12000.0) / 10.0, 40.0 * Math.ceil(f));
            min = Math.min(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored(), min);
            if (min > 0) {
                this.cond.drainPower(EnergyConversor.RFtoW(min));
                this.storage.modifyEnergyStored(min);
                this.lastProd = min;
                this.prodCount += min;
                this.working = true;
            } else {
                this.working = false;
            }
        } else {
            this.working = false;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.prodLastSec = this.prodCount;
            this.prodCount = 0;
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.storage.getEnergyStored() > 0 && (t = MgUtils.getTileEntity((TileEntity)this, this.getDirection())) instanceof IEnergyReceiver && (e = (IEnergyReceiver)t).canConnectEnergy(this.getDirection().opposite().toForgeDir())) {
            int transfer = Math.min(400, this.storage.getEnergyStored());
            int acepted = e.receiveEnergy(this.getDirection().opposite().toForgeDir(), transfer, false);
            this.storage.modifyEnergyStored(-acepted);
        }
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() - 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return (float)((double)(this.time - aux) * 1.0E-6);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return this.getDirection().toForgeDir() == from;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.storage.writeToNBT(nbt);
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return 0;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.storage.getEnergyStored());
        craft.func_71112_a(cont, 2, this.lastProd);
        craft.func_71112_a(cont, 3, this.prodLastSec);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.storage.setEnergyStored(value);
        }
        if (id == 2) {
            this.lastProd = value;
        }
        if (id == 3) {
            this.prodLastSec = value;
        }
    }

    public IEnergyTracker getEnergyTracker() {
        return new IEnergyTracker(){

            @Override
            public boolean isConsume() {
                return false;
            }

            @Override
            public float getMaxChange() {
                return 400.0f;
            }

            @Override
            public float getChangeInTheLastTick() {
                return TileKineticGenerator.this.lastProd;
            }

            @Override
            public float getChangeInTheLastSecond() {
                return TileKineticGenerator.this.prodLastSec;
            }
        };
    }
}

