/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.acces.RecipeOilDistillery;
import com.cout970.magneticraft.api.electricity.BufferedConductor;
import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileMB_Base;
import com.cout970.magneticraft.tileentity.TileMB_Energy_Low;
import com.cout970.magneticraft.tileentity.TileRefineryTank;
import com.cout970.magneticraft.util.fluid.TankMg;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileOilDistillery
extends TileMB_Base
implements IGuiSync,
IElectricTile {
    public int drawCounter;
    private TankMg input;
    private TankMg output;
    public IElectricConductor side1;
    public IElectricConductor side2;
    public IElectricConductor own = new BufferedConductor(this, 0.01, 8000, 140.0, 160.0);
    private double[] flow = new double[3];

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.input == null || this.output == null || this.side1 == null || this.side2 == null) {
            this.search();
        } else {
            RecipeOilDistillery recipe;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            this.valance(this.side1, this.side2, 0);
            this.valance(this.side1, this.own, 1);
            this.valance(this.own, this.side2, 2);
            this.own.recache();
            this.own.iterate();
            if (this.own.getVoltage() > 120.0 && this.input.getFluidAmount() > 0 && this.output.getSpace() > 0 && (recipe = RecipeOilDistillery.getRecipe(this.input.getFluid())) != null && (MgUtils.areEcuals(recipe.getOutput(), this.output.getFluid()) || this.output.getFluid() == null) && this.output.getSpace() >= recipe.getOutput().amount) {
                this.input.drain(recipe.getInput().amount, true);
                this.output.fill(recipe.getOutput(), true);
                this.own.drainPower(recipe.getEnergyCost());
            }
        }
    }

    private void valance(IElectricConductor a, IElectricConductor b, int i) {
        double resistence = a.getResistance() + b.getResistance();
        double difference = a.getVoltage() - b.getVoltage();
        double change = this.flow[i];
        double slow = change * resistence;
        int n = i;
        this.flow[n] = this.flow[n] + (difference - slow) * a.getIndScale() / a.getVoltageMultiplier();
        a.applyCurrent(-(change += difference * a.getCondParallel() / a.getVoltageMultiplier()));
        b.applyCurrent(change);
    }

    private void search() {
        VecInt vec = this.getDirection().opposite().toVecInt().multiply(2);
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileRefineryTank) {
            this.input = ((TileRefineryTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec = this.getDirection().opposite().toVecInt().add(0, 1, 0))) instanceof TileRefineryTank) {
            this.output = ((TileRefineryTank)t).getTank();
        }
        vec = this.getDirection().opposite().toVecInt().multiply(2).add(0, -1, 0);
        vec.add(this.getDirection().opposite().step(MgDirection.UP).toVecInt());
        t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileMB_Energy_Low) {
            this.side1 = ((TileMB_Energy_Low)t).getConds(VecInt.NULL_VECTOR, 0).getCond(0);
        }
        vec = this.getDirection().opposite().toVecInt().multiply(2).add(0, -1, 0);
        vec.add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt());
        t = MgUtils.getTileEntity((TileEntity)this, vec);
        if (t instanceof TileMB_Energy_Low) {
            this.side2 = ((TileMB_Energy_Low)t).getConds(VecInt.NULL_VECTOR, 0).getCond(0);
        }
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.own.getVoltage());
        craft.func_71112_a(cont, 1, this.own.getStorage());
        if (this.input != null && this.output != null) {
            if (this.input.getFluidAmount() > 0) {
                craft.func_71112_a(cont, 2, this.input.getFluid().getFluidID());
                craft.func_71112_a(cont, 3, this.input.getFluidAmount());
            } else {
                craft.func_71112_a(cont, 2, -1);
            }
            if (this.output.getFluidAmount() > 0) {
                craft.func_71112_a(cont, 4, this.output.getFluid().getFluidID());
                craft.func_71112_a(cont, 5, this.output.getFluidAmount());
            } else {
                craft.func_71112_a(cont, 4, -1);
            }
        }
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.own.setVoltage(value);
        } else if (id == 1) {
            this.own.setStorage(value);
        }
        if (this.input == null || this.output == null) {
            return;
        }
        if (id == 2) {
            if (value == -1) {
                this.input.setFluid(null);
            } else {
                this.input.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
        if (id == 3) {
            this.input.getFluid().amount = value;
        }
        if (id == 4) {
            if (value == -1) {
                this.output.setFluid(null);
            } else {
                this.output.setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
        if (id == 5) {
            this.output.getFluid().amount = value;
        }
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6 + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6, 2);
        }
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.own.load(nbt);
        this.flow[0] = nbt.func_74769_h("Conn1");
        this.flow[1] = nbt.func_74769_h("Conn2");
        this.flow[2] = nbt.func_74769_h("Conn3");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.own.save(nbt);
        nbt.func_74780_a("Conn1", this.flow[0]);
        nbt.func_74780_a("Conn2", this.flow[1]);
        nbt.func_74780_a("Conn3", this.flow[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public TankMg getInput() {
        return this.input;
    }

    public TankMg getOutput() {
        return this.output;
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int Vtier) {
        if (dir == VecInt.NULL_VECTOR) {
            return new CompoundElectricCables(this.own);
        }
        return null;
    }
}

