/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.ManagerBlocks;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.BlockInfo;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.block.BlockMg;
import com.cout970.magneticraft.update1_8.IFluidHandler1_8;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TilePumpJack
extends TileConductorLow
implements IFluidHandler1_8 {
    public float m;
    public MgDirection facing;
    public boolean active;
    public TankMg tank = new TankMg(this, 4000);
    public long time;
    private List<VecInt> pipes = new LinkedList<VecInt>();
    private List<VecInt> oil = new LinkedList<VecInt>();
    private List<VecInt> finder = new LinkedList<VecInt>();
    private List<VecInt> Visited = new LinkedList<VecInt>();
    private int alt;
    private boolean update;
    private int cooldown;
    private boolean blocked;
    private MgDirection[] sides = new MgDirection[]{MgDirection.NORTH, MgDirection.EAST, MgDirection.SOUTH, MgDirection.WEST, MgDirection.DOWN, MgDirection.UP};
    private int buffer;
    public static Block replacement = ManagerBlocks.oilSourceDrained;
    private int speed = 50;
    private boolean working;

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.update) {
            this.facing = this.getOrientation(this.func_145832_p());
        }
        this.working = this.cond.getVoltage() > 120.0;
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isActive()) {
                this.setActive(true);
            } else if (!this.working && this.isActive()) {
                this.setActive(false);
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.update) {
            if (this.field_145850_b.field_73011_w.getWorldTime() % 80L == 0L) {
                this.update = this.searchForOil();
            }
            this.export();
            return;
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            if (this.alt != 0) {
                Block b;
                this.pipes.clear();
                for (int y = this.field_145848_d - 1; y > 0 && !Block.func_149680_a((Block)(b = this.field_145850_b.func_147439_a(this.field_145851_c + this.facing.getOffsetX(), y, this.field_145849_e + this.facing.getOffsetZ())), (Block)ManagerBlocks.oilSource) && !Block.func_149680_a((Block)b, (Block)replacement); --y) {
                    if (Block.func_149680_a((Block)b, (Block)ManagerBlocks.concreted_pipe)) continue;
                    this.pipes.add(new VecInt(this.field_145851_c + this.facing.getOffsetX(), y, this.field_145849_e + this.facing.getOffsetZ()));
                }
            }
            this.blocked = false;
        }
        this.export();
        if (!this.blocked) {
            if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.cooldown <= 0) {
                this.cooldown = 20;
                if (this.pipes.size() == 0) {
                    this.getOil();
                    this.blocked = true;
                } else if (this.cond.getVoltage() > 120.0) {
                    VecInt c = this.pipes.get(0);
                    this.ReplaceBlock(c.getX(), c.getY(), c.getZ(), ManagerBlocks.concreted_pipe);
                    this.cond.drainPower(EnergyConversor.RFtoW(80.0));
                    this.pipes.remove(0);
                }
            }
        }
        if (this.blocked) {
            if (this.cond.getVoltage() > 120.0 && this.tank.getSpace() > 0 && this.buffer > 0) {
                int i = Math.min(this.speed, this.buffer);
                this.buffer -= this.tank.fill(FluidRegistry.getFluidStack((String)"oil", (int)i), true);
                this.cond.drainPower(EnergyConversor.RFtoW(i));
            }
            if (this.buffer <= 0) {
                if (this.oil.size() == 0) {
                    this.update = false;
                    this.blocked = false;
                    return;
                }
                VecInt b = this.oil.get(0);
                int m = this.field_145850_b.func_72805_g(b.getX(), b.getY(), b.getZ());
                if (m > 0) {
                    this.field_145850_b.func_72921_c(b.getX(), b.getY(), b.getZ(), m - 1, 2);
                } else {
                    this.field_145850_b.func_147449_b(b.getX(), b.getY(), b.getZ(), replacement);
                    this.oil.remove(0);
                }
                this.buffer = 1000;
            }
        }
    }

    public void ReplaceBlock(int x, int y, int z, Block remplace) {
        if (this.field_145850_b.func_147439_a(x, y, z).isAir((IBlockAccess)this.field_145850_b, x, y, z) || MgUtils.isMineableBlock(this.field_145850_b, new BlockInfo(this.field_145850_b.func_147439_a(x, y, z), this.field_145850_b.func_72805_g(x, y, z), x, y, z))) {
            ArrayList items = new ArrayList();
            Block id = this.field_145850_b.func_147439_a(x, y, z);
            int metadata = this.field_145850_b.func_72805_g(x, y, z);
            items = id.getDrops(this.field_145850_b, x, y, z, metadata, 0);
            for (ItemStack i : items) {
                BlockMg.dropItem(i, this.field_145850_b.field_73012_v, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b);
            }
            this.field_145850_b.func_147449_b(x, y, z, remplace);
        }
    }

    private void setActive(boolean b) {
        this.active = b;
        this.sendUpdateToClient();
    }

    public boolean isActive() {
        return this.active;
    }

    private void export() {
        if (this.tank.getFluidAmount() > 0) {
            for (MgDirection d : MgDirection.VALID_DIRECTIONS) {
                TileEntity t = MgUtils.getTileEntity((TileEntity)this, d);
                if (!(t instanceof IFluidHandler)) continue;
                IFluidHandler f = (IFluidHandler)t;
                if (f.canFill(d.toForgeDir(), FluidRegistry.getFluid((String)"oil"))) {
                    int m = f.fill(d.toForgeDir(), this.tank.drain(100, false), true);
                    this.tank.drain(m, true);
                }
                if (this.tank.getFluidAmount() == 0) break;
            }
        }
    }

    private void getOil() {
        this.oil.clear();
        this.pathFinder(new VecInt(this.field_145851_c, this.alt, this.field_145849_e));
        this.Visited.clear();
        this.finder.clear();
    }

    public void pathFinder(VecInt c) {
        if (this.oil.size() > 20) {
            return;
        }
        if (this.Visited.size() > 4000) {
            --this.alt;
            return;
        }
        for (MgDirection d : this.sides) {
            VecInt bc = new VecInt(c.getX() + d.getOffsetX(), c.getY() + d.getOffsetY(), c.getZ() + d.getOffsetZ());
            if (this.Visited.contains(bc)) continue;
            this.Visited.add(bc);
            Block b = this.field_145850_b.func_147439_a(bc.getX(), bc.getY(), bc.getZ());
            int m = this.field_145850_b.func_72805_g(bc.getX(), bc.getY(), bc.getZ());
            if (Block.func_149680_a((Block)b, (Block)ManagerBlocks.oilSource)) {
                this.oil.add(bc);
                if (this.finder.contains(bc)) continue;
                this.finder.add(bc);
                continue;
            }
            if (!Block.func_149680_a((Block)b, (Block)replacement) || this.finder.contains(bc)) continue;
            this.finder.add(bc);
        }
        ArrayList<VecInt> temp = new ArrayList<VecInt>();
        temp.addAll(this.finder);
        for (VecInt cc : temp) {
            this.finder.remove(cc);
            this.pathFinder(cc);
        }
    }

    public boolean searchForOil() {
        this.pipes.clear();
        for (int y = this.field_145848_d - 1; y > 0; --y) {
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c + this.facing.getOffsetX(), y, this.field_145849_e + this.facing.getOffsetZ());
            if (Block.func_149680_a((Block)b, (Block)ManagerBlocks.oilSource) || Block.func_149680_a((Block)b, (Block)replacement)) {
                this.alt = y;
                this.getOil();
                if (this.oil.isEmpty()) {
                    this.alt = 0;
                    continue;
                }
                return true;
            }
            if (Block.func_149680_a((Block)b, (Block)ManagerBlocks.concreted_pipe)) continue;
            this.pipes.add(new VecInt(this.field_145851_c + this.facing.getOffsetX(), y, this.field_145849_e + this.facing.getOffsetZ()));
        }
        return false;
    }

    @Override
    public int fillMg(MgDirection from, FluidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public FluidStack drainMg_F(MgDirection from, FluidStack resource, boolean doDrain) {
        return this.drainMg(from, resource.amount, doDrain);
    }

    @Override
    public FluidStack drainMg(MgDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFillMg(MgDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public boolean canDrainMg(MgDirection from, Fluid fluid) {
        return fluid.getName() == "oil";
    }

    @Override
    public FluidTankInfo[] getTankInfoMg(MgDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    public MgDirection getOrientation(int meta) {
        if (meta == 0) {
            return MgDirection.EAST;
        }
        if (meta == 1) {
            return MgDirection.SOUTH;
        }
        if (meta == 2) {
            return MgDirection.WEST;
        }
        if (meta == 3) {
            return MgDirection.NORTH;
        }
        return MgDirection.NORTH;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "oil");
        this.buffer = nbt.func_74762_e("Buffer");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "oil");
        nbt.func_74768_a("Buffer", this.buffer);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this instanceof IFluidHandler1_8) {
            return this.fillMg(MgDirection.getDirection(from.ordinal()), resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg_F(MgDirection.getDirection(from.ordinal()), resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this instanceof IFluidHandler1_8) {
            return this.drainMg(MgDirection.getDirection(from.ordinal()), maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canFillMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this instanceof IFluidHandler1_8) {
            return this.canDrainMg(MgDirection.getDirection(from.ordinal()), fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (this instanceof IFluidHandler1_8) {
            return this.getTankInfoMg(MgDirection.getDirection(from.ordinal()));
        }
        return null;
    }
}

