/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import mods.railcraft.api.electricity.IElectricGrid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileRCAlternator
extends TileConductorLow
implements IElectricGrid {
    private IElectricGrid.ChargeHandler charge = new IElectricGrid.ChargeHandler(this, IElectricGrid.ChargeHandler.ConnectType.BLOCK);
    public int maxStorage = 10000;
    public double level = 180.0;

    @Override
    public IElectricConductor initConductor() {
        return new ElectricConductor(this){

            @Override
            public void iterate() {
                super.iterate();
                if (!TileRCAlternator.this.isControled()) {
                    return;
                }
                if (this.getVoltage() < TileRCAlternator.this.level && TileRCAlternator.this.charge.getCharge() > 0.0) {
                    int change = (int)Math.min((TileRCAlternator.this.level - this.getVoltage()) * 10.0, 512.0);
                    change = (int)Math.min((double)change, TileRCAlternator.this.charge.getCharge());
                    this.applyPower(EnergyConversor.RCtoW(change));
                    TileRCAlternator.this.charge.addCharge(-change);
                } else if (this.getVoltage() > TileRCAlternator.this.level && TileRCAlternator.this.charge.getCharge() < (double)TileRCAlternator.this.maxStorage) {
                    int change = (int)Math.min((this.getVoltage() - TileRCAlternator.this.level) * 10.0, 512.0);
                    change = (int)Math.min((double)change, (double)TileRCAlternator.this.maxStorage - TileRCAlternator.this.charge.getCharge());
                    this.drainPower(EnergyConversor.RCtoW(change));
                    TileRCAlternator.this.charge.addCharge(change);
                }
            }

            @Override
            public int getStorage() {
                return (int)TileRCAlternator.this.charge.getCharge();
            }

            @Override
            public int getMaxStorage() {
                return TileRCAlternator.this.maxStorage;
            }

            @Override
            public void setStorage(int charg) {
                TileRCAlternator.this.charge.setCharge(charg);
            }

            @Override
            public void applyCharge(int charg) {
                TileRCAlternator.this.charge.addCharge(charg);
                if (TileRCAlternator.this.charge.getCharge() > (double)TileRCAlternator.this.maxStorage) {
                    TileRCAlternator.this.charge.addCharge(TileRCAlternator.this.maxStorage);
                }
            }

            @Override
            public void drainCharge(int charg) {
                TileRCAlternator.this.charge.addCharge(-charg);
                if (TileRCAlternator.this.charge.getCharge() < 0.0) {
                    TileRCAlternator.this.charge.setCharge(0.0);
                }
            }

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileRCAlternator.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public boolean isAbleToConnect(IElectricConductor c, VecInt d) {
                return TileRCAlternator.this.getDirection().opposite().toVecInt().equals(d);
            }
        };
    }

    @Override
    public IElectricGrid.ChargeHandler getChargeHandler() {
        return this.charge;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.charge.tick();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.charge.readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.charge.writeToNBT(nbt);
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }
}

