/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ConnectionClass;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileBase;
import com.cout970.magneticraft.util.IGuiListener;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileResistance
extends TileBase
implements IGuiListener,
IGuiSync,
IElectricTile {
    public static final VecInt[] color_array = new VecInt[]{new VecInt(0, 0, 0), new VecInt(102, 51, 50), new VecInt(255, 0, 0), new VecInt(255, 102, 0), new VecInt(255, 255, 0), new VecInt(51, 204, 51), new VecInt(103, 102, 255), new VecInt(205, 102, 255), new VecInt(147, 147, 147), new VecInt(255, 255, 255)};
    public IElectricConductor cond1;
    public IElectricConductor cond2;
    public int line1 = 0;
    public int line2 = 1;
    public int line3 = 0;
    public int select = 0;
    public double I = 0.0;
    public double resistance = 1.0;

    public TileResistance() {
        this.initConductors();
    }

    @Override
    public void onNeigChange() {
        super.onNeigChange();
        this.cond1.disconect();
        this.cond2.disconect();
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.cond1.recache();
        this.cond2.recache();
        this.cond1.iterate();
        this.cond2.iterate();
        double V = this.cond1.getVoltage() - this.cond2.getVoltage();
        this.I = V / this.getResistance();
        this.cond2.applyCurrent(this.I);
        this.cond1.applyCurrent(-this.I);
    }

    public void initConductors() {
        this.cond1 = new ElectricConductor(this){

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileResistance.this.getDirection().toVecInt()};
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_LOW;
            }
        };
        this.cond2 = new ElectricConductor(this){

            @Override
            public VecInt[] getValidConnections() {
                return new VecInt[]{TileResistance.this.getDirection().opposite().toVecInt()};
            }

            @Override
            public ConnectionClass getConnectionClass(VecInt v) {
                return ConnectionClass.CABLE_LOW;
            }
        };
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int tier) {
        if (tier != 0) {
            return null;
        }
        if (this.getDirection().opposite().toVecInt().equals(dir)) {
            return new CompoundElectricCables(this.cond2);
        }
        if (this.getDirection().toVecInt().equals(dir)) {
            return new CompoundElectricCables(this.cond1);
        }
        if (dir == VecInt.NULL_VECTOR) {
            return new CompoundElectricCables(this.cond1, this.cond2);
        }
        return null;
    }

    public double getResistance() {
        return this.resistance;
    }

    public void setResistance(double res) {
        this.resistance = res;
    }

    @Override
    public void onMessageReceive(int id, int dato) {
        if (id == 0) {
            this.line1 = dato;
        } else if (id == 1) {
            this.line2 = dato;
        } else if (id == 2) {
            this.line3 = dato;
        } else if (id == -2) {
            this.select = dato;
        }
        this.updateResistance();
        this.sendUpdateToClient();
    }

    private void updateResistance() {
        if (this.line1 == 0 && this.line2 == 0) {
            return;
        }
        double res = 1.0;
        res *= (double)this.line2;
        res += (double)(this.line1 * 10);
        for (int i = 0; i < this.line3; ++i) {
            res *= 10.0;
        }
        if (res <= 0.0) {
            res = 1.0;
        }
        this.setResistance(res);
    }

    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p());
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 1, (int)(this.I * 1000.0));
        craft.func_71112_a(cont, 2, (int)(this.cond1.getVoltage() * 1000.0));
        craft.func_71112_a(cont, 3, (int)(this.cond2.getVoltage() * 1000.0));
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 1) {
            this.I = (double)value / 1000.0;
        } else if (id == 2) {
            this.cond1.setVoltage((double)value / 1000.0);
        } else if (id == 3) {
            this.cond2.setVoltage((double)value / 1000.0);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.line1 = Math.abs(nbt.func_74762_e("Line_1") % color_array.length);
        this.line2 = Math.abs(nbt.func_74762_e("Line_2") % color_array.length);
        this.line3 = Math.abs(nbt.func_74762_e("Line_3") % color_array.length);
        this.select = nbt.func_74762_e("Select");
        NBTTagList list = nbt.func_150295_c("Conductors", 10);
        this.cond1.load(list.func_150305_b(0));
        this.cond2.load(list.func_150305_b(1));
        this.updateResistance();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Line_1", this.line1);
        nbt.func_74768_a("Line_2", this.line2);
        nbt.func_74768_a("Line_3", this.line3);
        this.updateResistance();
        nbt.func_74768_a("Select", this.select);
        NBTTagList list = new NBTTagList();
        NBTTagCompound nbtCond1 = new NBTTagCompound();
        this.cond1.save(nbtCond1);
        list.func_74742_a((NBTBase)nbtCond1);
        NBTTagCompound nbtCond2 = new NBTTagCompound();
        this.cond2.save(nbtCond2);
        list.func_74742_a((NBTBase)nbtCond2);
        nbt.func_74782_a("Conductors", (NBTBase)list);
    }
}

