/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileCopperTank;
import com.cout970.magneticraft.tileentity.TileMB_Base;
import com.cout970.magneticraft.util.fluid.TankMg;
import com.cout970.magneticraft.util.multiblock.Multiblock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileSteamTurbineControl
extends TileMB_Base
implements IGuiSync {
    private static final int MAX_STEAM = 1200;
    public TankMg[] in = new TankMg[4];
    public IElectricConductor out;
    private double prod;
    private double counter;
    public int drawCounter;
    public float animation;
    public float speed;
    private long time;
    public IElectricConductor capacity = new ElectricConductor(this, 2, 0.05){

        @Override
        public double getInvCapacity() {
            return EnergyConversor.RFtoW(1.0);
        }

        @Override
        public double getVoltageMultiplier() {
            return 100.0;
        }
    };
    private double flow;

    private void updateConductor() {
        if (this.out == null) {
            return;
        }
        double resistence = this.out.getResistance() + this.capacity.getResistance();
        double difference = this.out.getVoltage() - this.capacity.getVoltage();
        double change = this.flow;
        double slow = change * resistence;
        this.flow += (difference - change * resistence) * this.out.getIndScale() / this.out.getVoltageMultiplier();
        this.out.applyCurrent(-(change += difference * this.out.getCondParallel() / this.out.getVoltageMultiplier()));
        this.capacity.applyCurrent(change);
    }

    public boolean isActive() {
        return this.func_145832_p() > 6;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.in[0] == null || this.out == null || this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.search();
            return;
        }
        float activity = 0.5f * ((float)this.getFluidAmount() / 64000.0f);
        if (activity < 0.01f) {
            activity = 0.0f;
        }
        if (this.speed < activity) {
            this.speed += 0.03125f;
        } else if (this.speed > activity) {
            this.speed -= 0.03125f;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateConductor();
        this.balanceTanks();
        double miss = (240.0 - this.capacity.getVoltage() / 100.0) * 100.0;
        int steam = (int)Math.min(Math.min(this.getFluidAmount() > 1000 ? (double)(this.getFluidAmount() + 1000) : (double)this.getFluidAmount(), miss), 1200.0);
        steam = (int)Math.min((float)steam, (float)(this.getFluidAmount() + 1000) / 64000.0f * 1200.0f);
        if (steam > 0 && this.capacity.getVoltage() < 24000.0) {
            this.drain(steam, true);
            double p = EnergyConversor.STEAMtoW(steam);
            this.capacity.applyPower(p);
            this.counter += p;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 1L) {
            this.prod = this.counter / 20.0;
            this.counter = 0.0;
        }
    }

    private void balanceTanks() {
        int sum = this.getFluidAmount();
        int rest = sum % 4;
        for (TankMg t : this.in) {
            t.setFluid(null);
            t.fill(FluidRegistry.getFluidStack((String)"steam", (int)(sum / 4)), true);
            if (rest <= 0) continue;
            rest -= t.fill(FluidRegistry.getFluidStack((String)"steam", (int)rest), true);
        }
    }

    public void drain(int steam, boolean b) {
        for (int i = 0; i < 4; ++i) {
            if (this.in[i].getFluid() == null || this.in[i].getFluid().getFluid() != FluidRegistry.getFluid((String)"steam")) continue;
            int extract = Math.min(this.in[i].getFluidAmount(), steam);
            this.in[i].drain(extract, b);
            steam -= extract;
        }
    }

    public int getFluidAmount() {
        int steam = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.in[i] == null || this.in[i].getFluid() == null || this.in[i].getFluid().getFluid() != FluidRegistry.getFluid((String)"steam")) continue;
            steam += this.in[i].getFluidAmount();
        }
        return steam;
    }

    private void search() {
        VecInt vec = this.getDirection().toVecInt().getOpposite();
        TileEntity t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(this.getDirection().opposite().step(MgDirection.UP).toVecInt()));
        if (t instanceof TileCopperTank) {
            this.in[0] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt()))) instanceof TileCopperTank) {
            this.in[1] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(2).add(this.getDirection().opposite().step(MgDirection.UP).toVecInt()))) instanceof TileCopperTank) {
            this.in[2] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().multiply(2).add(this.getDirection().opposite().step(MgDirection.DOWN).toVecInt()))) instanceof TileCopperTank) {
            this.in[3] = ((TileCopperTank)t).getTank();
        }
        if ((t = MgUtils.getTileEntity((TileEntity)this, vec.copy().add(new VecInt(0, 1, 0)))) instanceof IElectricTile) {
            this.out = ((IElectricTile)t).getConds(vec.getOpposite(), 2).getCond(0);
        }
    }

    @Override
    public void onDestroy(World w, VecInt p, Multiblock c, MgDirection e) {
        this.setActive(false);
        this.in = new TankMg[4];
        this.out = null;
    }

    @Override
    public void onActivate(World w, VecInt p, Multiblock c, MgDirection e) {
        this.setActive(true);
    }

    private void setActive(boolean b) {
        if (b) {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6 + 6, 2);
        } else {
            this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145832_p() % 6, 2);
        }
    }

    public int getCapacity() {
        return 64000;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        if (this.out != null) {
            craft.func_71112_a(cont, 0, (int)this.capacity.getVoltage());
        }
        craft.func_71112_a(cont, 1, (int)this.prod);
        for (int i = 0; i < 4; ++i) {
            if (this.in[i] == null) continue;
            if (this.in[i].getFluidAmount() > 0) {
                craft.func_71112_a(cont, i * 2 + 2, this.in[i].getFluid().getFluidID());
                craft.func_71112_a(cont, i * 2 + 3, this.in[i].getFluidAmount());
                continue;
            }
            craft.func_71112_a(cont, i * 2 + 2, -1);
        }
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        int i;
        if (id == 0) {
            this.capacity.setVoltage(value);
        }
        if (id == 1) {
            this.prod = value;
        }
        if (id >= 2 && id <= 9 && this.in[i = (id - 2) / 2] != null) {
            if (id - i * 2 + 2 != 0) {
                if (this.in[i].getFluid() != null) {
                    this.in[i].setFluid(new FluidStack(this.in[i].getFluid(), value));
                }
            } else if (value == -1) {
                this.in[i].setFluid(null);
            } else {
                this.in[i].setFluid(new FluidStack(FluidRegistry.getFluid((int)value), 1));
            }
        }
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return this.time - aux;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList conduit = nbt.func_150295_c("Capacity_cond", 10);
        NBTTagCompound conduit_nbt = conduit.func_150305_b(0);
        this.capacity.load(conduit_nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList conduit = new NBTTagList();
        NBTTagCompound conduit_nbt = new NBTTagCompound();
        this.capacity.save(conduit_nbt);
        conduit.func_74742_a((NBTBase)conduit_nbt);
        nbt.func_74782_a("Capacity_cond", (NBTBase)conduit);
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return String.format("Generating: %.3f kW", TileSteamTurbineControl.this.prod / 1000.0);
            }

            @Override
            public float getMaxLevel() {
                return (float)EnergyConversor.STEAMtoW(1200.0);
            }

            @Override
            public float getLevel() {
                return (float)Math.min(TileSteamTurbineControl.this.prod, (double)this.getMaxLevel());
            }
        };
    }
}

