/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.heat.CompoundHeatCables;
import com.cout970.magneticraft.api.heat.IHeatConductor;
import com.cout970.magneticraft.api.heat.IHeatTile;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.MgUtils;
import com.cout970.magneticraft.api.util.VecDouble;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileMB_Base;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.multiblock.Multiblock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileStirlingGenerator
extends TileMB_Base
implements IInventoryManaged,
IGuiSync,
IElectricTile,
IHeatTile {
    private static final double MAX_PRODUCTION = 1200.0;
    public IHeatConductor heat;
    public InventoryComponent inv = new InventoryComponent(this, 1, "Stirling generator");
    public IElectricConductor cond;
    public int oldHeat;
    private int progress;
    private boolean working;
    private int maxProgres;
    public int drawCounter = 0;
    private boolean burning;
    private double prodCounter;
    private double prodSecond;

    @Override
    public void func_145845_h() {
        int i;
        super.func_145845_h();
        if (this.drawCounter > 0) {
            --this.drawCounter;
        }
        if (!this.isActive()) {
            return;
        }
        if (this.cond == null || this.heat == null) {
            this.search();
        }
        if (this.isWorking() && this.field_145850_b.func_82737_E() % 2L == 0L) {
            for (i = 0; i < 2; ++i) {
                VecDouble vec = new VecDouble((double)this.field_145851_c + 0.5, (double)this.field_145848_d - 0.2, (double)this.field_145849_e + 0.5);
                MgDirection dir = this.getDirection();
                vec.add((double)dir.getOffsetX() * 0.3, 0.0, (double)dir.getOffsetZ() * 0.3);
                Random r = this.field_145850_b.field_73012_v;
                dir = dir.step(MgDirection.UP);
                vec.add((double)dir.getOffsetX() * (0.5 - r.nextDouble()), 0.0, (double)dir.getOffsetZ() * (0.5 - r.nextDouble()));
                if (r.nextBoolean()) {
                    this.field_145850_b.func_72869_a("flame", vec.getX(), vec.getY(), vec.getZ(), 0.003125 - 0.00625 * r.nextDouble(), 0.003125 * (double)r.nextInt(15), 0.003125 - 0.00625 * r.nextDouble());
                    continue;
                }
                this.field_145850_b.func_72869_a("smoke", vec.getX(), vec.getY(), vec.getZ(), 0.003125 - 0.00625 * r.nextDouble(), 0.003125 * (double)r.nextInt(15), 0.003125 - 0.00625 * r.nextDouble());
            }
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            if (this.working && !this.isWorking()) {
                this.setActive(true);
            } else if (!this.working && this.isWorking()) {
                this.setActive(false);
            }
        }
        if (this.cond == null || this.heat == null) {
            return;
        }
        if (this.progress > 0 && this.heat.getTemperature() < this.heat.getMaxTemp() - 200.0 && this.isControled()) {
            i = 12;
            if (this.progress - i < 0) {
                this.heat.applyCalories(EnergyConversor.FUELtoCALORIES(this.progress));
                this.progress = 0;
            } else {
                this.progress -= i;
                this.heat.applyCalories(EnergyConversor.FUELtoCALORIES(i));
            }
        }
        if (this.progress <= 0) {
            int fuel;
            this.working = false;
            if (this.getInv().func_70301_a(0) != null && this.isControled() && (fuel = TileEntityFurnace.func_145952_a((ItemStack)this.getInv().func_70301_a(0))) > 0 && this.heat.getTemperature() < this.heat.getMaxTemp()) {
                this.progress = fuel;
                this.maxProgres = fuel;
                if (this.getInv().func_70301_a(0) != null) {
                    --this.getInv().func_70301_a((int)0).field_77994_a;
                    if (this.getInv().func_70301_a((int)0).field_77994_a <= 0) {
                        this.getInv().func_70299_a(0, this.getInv().func_70301_a(0).func_77973_b().getContainerItem(this.getInv().func_70301_a(0)));
                    }
                }
                this.working = true;
                this.func_70296_d();
            }
        }
        if (this.heat.getTemperature() > 30.0 && this.cond.getVoltage() < 240.0) {
            int prod = (int)Math.min(1200.0, (this.heat.getTemperature() - 30.0) * 10.0);
            this.heat.drainCalories(EnergyConversor.WtoCALORIES(prod));
            this.cond.applyPower(prod);
            this.prodCounter += (double)prod;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.prodSecond = this.prodCounter;
            this.prodCounter = 0.0;
        }
        if ((int)this.heat.getTemperature() != this.oldHeat && this.field_145850_b.field_73011_w.getWorldTime() % 10L == 0L) {
            this.sendUpdateToClient();
            this.oldHeat = (int)this.heat.getTemperature();
        }
    }

    private void search() {
        VecInt dir = this.getDirection().opposite().toVecInt();
        TileEntity tile = MgUtils.getTileEntity((TileEntity)this, dir);
        if (tile instanceof IHeatTile) {
            CompoundHeatCables comp = ((IHeatTile)tile).getHeatCond(VecInt.NULL_VECTOR);
            this.heat = comp.getCond(0);
        }
        if ((tile = MgUtils.getTileEntity((TileEntity)this, dir.copy().multiply(2))) instanceof IElectricTile) {
            this.cond = ((IElectricTile)tile).getConds(VecInt.NULL_VECTOR, 0).getCond(0);
        }
    }

    private void setActive(boolean b) {
        this.burning = b;
        this.sendUpdateToClient();
    }

    public boolean isWorking() {
        return this.burning;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74762_e("Progres");
        this.maxProgres = nbt.func_74762_e("maxProgres");
        this.burning = nbt.func_74767_n("Burning");
        this.working = nbt.func_74767_n("Working");
        this.getInv().readFromNBT(nbt);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Progres", this.progress);
        nbt.func_74768_a("maxProgres", this.maxProgres);
        nbt.func_74757_a("Burning", this.burning);
        nbt.func_74757_a("Working", this.working);
        this.getInv().writeToNBT(nbt);
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        if (this.cond == null || this.heat == null) {
            return;
        }
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.progress);
        craft.func_71112_a(cont, 2, this.cond.getStorage());
        craft.func_71112_a(cont, 3, this.maxProgres);
        craft.func_71112_a(cont, 4, (int)this.heat.getTemperature() * 10);
        craft.func_71112_a(cont, 5, (int)this.prodSecond);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (this.cond == null || this.heat == null) {
            return;
        }
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.progress = value;
        }
        if (id == 2) {
            this.cond.setStorage(value);
        }
        if (id == 3) {
            this.maxProgres = value;
        }
        if (id == 4) {
            this.heat.setTemperature(value / 10);
        }
        if (id == 5) {
            this.prodSecond = (double)value / 20.0;
        }
    }

    @Override
    public void onDestroy(World w, VecInt p, Multiblock c, MgDirection e) {
        this.heat = null;
        this.cond = null;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70298_a(int a, int b) {
        return this.getInv().func_70298_a(a, b);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    @Override
    public MgDirection getDirection() {
        return MgDirection.getDirection(this.func_145832_p() % 6);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public CompoundElectricCables getConds(VecInt dir, int Vtier) {
        if (VecInt.NULL_VECTOR.equals(dir)) {
            return new CompoundElectricCables(this.cond);
        }
        return null;
    }

    @Override
    public CompoundHeatCables getHeatCond(VecInt c) {
        if (VecInt.NULL_VECTOR.equals(c)) {
            return new CompoundHeatCables(this.heat);
        }
        return null;
    }

    public IBarProvider getBurningTimeBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return Math.max(TileStirlingGenerator.this.maxProgres, 1);
            }

            @Override
            public float getLevel() {
                return TileStirlingGenerator.this.progress;
            }
        };
    }

    public IBarProvider getProductionBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return "Production " + (int)TileStirlingGenerator.this.prodSecond + "W";
            }

            @Override
            public float getMaxLevel() {
                return (float)Math.max(1200.0, 1.0);
            }

            @Override
            public float getLevel() {
                return (float)TileStirlingGenerator.this.prodSecond;
            }
        };
    }

    public boolean isActive() {
        return this.func_145832_p() > 5;
    }
}

