/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.CompoundElectricCables;
import com.cout970.magneticraft.api.electricity.ElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.electricity.IElectricTile;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.tileentity.TileBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class TileTransformerMedium_High
extends TileBase
implements IElectricTile {
    public IElectricConductor medium = new ElectricConductor(this, 2, 0.01);
    public IElectricConductor high = new ElectricConductor(this, 4, 0.01);
    public double flow;

    @Override
    public CompoundElectricCables getConds(VecInt dir, int tier) {
        if (VecInt.NULL_VECTOR == dir) {
            return tier == 2 ? new CompoundElectricCables(this.medium) : (tier == 4 ? new CompoundElectricCables(this.high) : null);
        }
        MgDirection d = dir.toMgDirection();
        if (d == MgDirection.getDirection(this.func_145832_p()) && tier == 2) {
            return new CompoundElectricCables(this.medium);
        }
        if (d == MgDirection.getDirection(this.func_145832_p()).opposite() && tier == 4) {
            return new CompoundElectricCables(this.high);
        }
        return null;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.high.recache();
        this.medium.recache();
        this.medium.iterate();
        this.high.iterate();
        double resistence = this.medium.getResistance() + this.high.getResistance();
        double difference = this.medium.getVoltage() * (this.high.getVoltageMultiplier() / this.medium.getVoltageMultiplier()) - this.high.getVoltage();
        double change = this.flow;
        double slow = change * resistence;
        this.flow += (difference - slow) * this.high.getIndScale() / this.high.getVoltageMultiplier();
        this.medium.applyCurrent(-(change += difference * this.high.getCondParallel() / this.high.getVoltageMultiplier()));
        this.high.applyCurrent(change);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound nbtl = nbt.func_74775_l("c2");
        NBTTagCompound nbtm = nbt.func_74775_l("c1");
        this.high.load(nbtl);
        this.medium.load(nbtm);
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound nbtl = new NBTTagCompound();
        this.high.save(nbtl);
        NBTTagCompound nbtm = new NBTTagCompound();
        this.medium.save(nbtm);
        nbt.func_74782_a("c2", (NBTBase)nbtl);
        nbt.func_74782_a("c1", (NBTBase)nbtm);
    }
}

