/*
 * Decompiled with CFR 0.152.
 */
package com.cout970.magneticraft.tileentity;

import com.cout970.magneticraft.api.electricity.BufferedConductor;
import com.cout970.magneticraft.api.electricity.IElectricConductor;
import com.cout970.magneticraft.api.tool.IWindTurbine;
import com.cout970.magneticraft.api.util.EnergyConversor;
import com.cout970.magneticraft.api.util.IRenderizable;
import com.cout970.magneticraft.api.util.MgDirection;
import com.cout970.magneticraft.api.util.VecInt;
import com.cout970.magneticraft.client.gui.component.IBarProvider;
import com.cout970.magneticraft.client.gui.component.IEnergyTracker;
import com.cout970.magneticraft.client.gui.component.IGuiSync;
import com.cout970.magneticraft.tileentity.TileWindTurbineGap;
import com.cout970.magneticraft.util.FractalLib;
import com.cout970.magneticraft.util.IInventoryManaged;
import com.cout970.magneticraft.util.InventoryComponent;
import com.cout970.magneticraft.util.tile.TileConductorLow;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;

public class TileWindTurbine
extends TileConductorLow
implements IInventoryManaged,
IGuiSync {
    public int turbine = -1;
    public MgDirection facing = null;
    public float rotation;
    public long time;
    public InventoryComponent inv = new InventoryComponent(this, 1, "Wind Turbine");
    public boolean isDisplayed;
    public IRenderizable rend;
    public int oldTurbine = -2;
    private int tracer;
    private byte[] rayTrace;
    private int efficiency;
    private double wind;
    private int power;
    public float speed;
    private int height;
    private int lenght;
    private double turbinePotency;
    private float production;
    private float productionPerSecond;
    private float averageProdCalc;

    private void traceAir1() {
        int air;
        int yHeight = this.tracer / 17;
        int var2 = this.tracer % 17;
        MgDirection rightHand = this.facing.step(MgDirection.UP);
        VecInt pos = new VecInt(this);
        pos.add(this.facing.toVecInt().multiply(2));
        pos.add(rightHand.toVecInt().multiply(var2 - 8));
        pos.add(0, yHeight, 0);
        for (air = 0; air < 20 && Block.func_149680_a((Block)this.field_145850_b.func_147439_a(pos.getX(), pos.getY(), pos.getZ()), (Block)Blocks.field_150350_a); ++air) {
            pos.add(this.facing.toVecInt());
        }
        if (this.rayTrace == null) {
            this.rayTrace = new byte[289];
        }
        this.efficiency = this.efficiency - this.rayTrace[this.tracer] + air;
        this.rayTrace[this.tracer] = (byte)air;
        ++this.tracer;
        if (this.tracer >= 289) {
            this.tracer = 0;
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.facing == null) {
            this.facing = MgDirection.getDirection(this.func_145832_p());
        } else {
            if (this.field_145850_b.field_73011_w.getWorldTime() % 20L == 0L) {
                this.wind = 10000.0 * this.getWindSpeed();
                if (this.turbine != -1) {
                    this.power = (int)(this.wind * (double)this.efficiency / 5780.0);
                    this.speed = (float)(Math.sqrt(this.power) * (double)0.001f);
                }
                this.traceAir1();
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.productionPerSecond = this.averageProdCalc;
                this.averageProdCalc = 0.0f;
            }
            if (this.turbine == -1) {
                this.production = 0.0f;
                this.productionPerSecond = 0.0f;
            } else if (this.cond.getVoltage() <= 240.0 && this.isControled()) {
                this.cond.applyPower(EnergyConversor.RFtoW((double)this.power * this.turbinePotency / 100.0));
                this.production = (float)EnergyConversor.RFtoW((double)this.power * this.turbinePotency / 100.0);
            } else {
                this.production = 0.0f;
            }
            this.averageProdCalc += this.production;
        }
    }

    private double getWindSpeed() {
        BiomeGenBase biome;
        if (this.field_145850_b.field_73011_w.field_76575_d) {
            return 0.5;
        }
        double tot = FractalLib.noise1D(2576710L, (double)this.field_145850_b.func_82737_E() * 1.0E-4, 0.6f, 5);
        tot = Math.max(0.0, 1.6 * (tot - 0.5) + 0.5);
        if (this.field_145850_b.func_72912_H().func_76067_t() != WorldType.field_77138_c) {
            tot *= Math.sqrt(this.field_145848_d) / 16.0;
        }
        if ((biome = this.field_145850_b.func_72807_a(this.field_145851_c, this.field_145849_e)).func_76738_d()) {
            if (this.field_145850_b.func_72911_I()) {
                return 4.0 * tot;
            }
            if (this.field_145850_b.func_72896_J()) {
                return 0.5 + 0.5 * tot;
            }
        }
        return tot;
    }

    public void func_70299_a(int a, ItemStack b) {
        this.getInv().func_70299_a(a, b);
        this.check();
    }

    public ItemStack func_70298_a(int a, int b) {
        ItemStack c = this.getInv().func_70298_a(a, b);
        this.check();
        return c;
    }

    @Override
    public void onBlockBreaks() {
        if (this.isDisplayed) {
            this.desactivateTurbine();
        }
    }

    private void check() {
        ItemStack a = this.getInv().func_70301_a(0);
        if (a != null) {
            if (a.func_77973_b() instanceof IWindTurbine && this.turbine != ((IWindTurbine)a.func_77973_b()).getID()) {
                if (this.hasSpace((IWindTurbine)a.func_77973_b())) {
                    this.turbine = -1;
                    this.desactivateTurbine();
                    this.turbine = ((IWindTurbine)a.func_77973_b()).getID();
                    this.activateTurbine((IWindTurbine)a.func_77973_b());
                    this.sendUpdateToClient();
                }
            } else {
                if (this.isDisplayed) {
                    this.desactivateTurbine();
                }
                this.turbine = -1;
            }
        } else {
            if (this.isDisplayed) {
                this.desactivateTurbine();
            }
            this.turbine = -1;
        }
    }

    private boolean hasSpace(IWindTurbine item) {
        int h = item.getHeight();
        int l = item.getLenght();
        for (int y = -h + 1; y < h; ++y) {
            for (int v = -l + 1; v < l; ++v) {
                int i = 0;
                int k = 0;
                switch (this.facing) {
                    case NORTH: {
                        k = -1;
                        i = v;
                        break;
                    }
                    case SOUTH: {
                        k = 1;
                        i = v;
                        break;
                    }
                    case WEST: {
                        k = v;
                        i = -1;
                        break;
                    }
                    case EAST: {
                        k = v;
                        i = 1;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                if (this.field_145850_b.func_147437_c(this.field_145851_c + i, this.field_145848_d + y, this.field_145849_e + k) || this.field_145850_b.func_147439_a(this.field_145851_c + i, this.field_145848_d + y, this.field_145849_e + k) == this.func_145838_q()) continue;
                return false;
            }
        }
        return true;
    }

    public void desactivateTurbine() {
        this.isDisplayed = false;
        this.turbinePotency = 0.0;
        for (int y = -this.height + 1; y < this.height; ++y) {
            for (int v = -this.lenght + 1; v < this.lenght; ++v) {
                int i = 0;
                int k = 0;
                switch (this.facing) {
                    case NORTH: {
                        k = -1;
                        i = v;
                        break;
                    }
                    case SOUTH: {
                        k = 1;
                        i = v;
                        break;
                    }
                    case WEST: {
                        k = v;
                        i = -1;
                        break;
                    }
                    case EAST: {
                        k = v;
                        i = 1;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.field_145850_b.func_147449_b(this.field_145851_c + i, this.field_145848_d + y, this.field_145849_e + k, Blocks.field_150350_a);
            }
        }
    }

    public void activateTurbine(IWindTurbine w) {
        this.isDisplayed = true;
        this.height = w.getHeight();
        this.lenght = w.getLenght();
        this.turbinePotency = w.getPotency();
        for (int y = -this.height + 1; y < this.height; ++y) {
            for (int v = -this.lenght + 1; v < this.lenght; ++v) {
                int i = 0;
                int k = 0;
                switch (this.facing) {
                    case NORTH: {
                        k = -1;
                        i = v;
                        break;
                    }
                    case SOUTH: {
                        k = 1;
                        i = v;
                        break;
                    }
                    case WEST: {
                        k = v;
                        i = -1;
                        break;
                    }
                    case EAST: {
                        k = v;
                        i = 1;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.field_145850_b.func_147465_d(this.field_145851_c + i, this.field_145848_d + y, this.field_145849_e + k, this.func_145838_q(), 15, 2);
                TileEntity t = this.field_145850_b.func_147438_o(this.field_145851_c + i, this.field_145848_d + y, this.field_145849_e + k);
                if (!(t instanceof TileWindTurbineGap)) continue;
                ((TileWindTurbineGap)t).x = this.field_145851_c;
                ((TileWindTurbineGap)t).y = this.field_145848_d;
                ((TileWindTurbineGap)t).z = this.field_145849_e;
            }
        }
    }

    public float getDelta() {
        long aux = this.time;
        this.time = System.nanoTime();
        return (float)((double)(this.time - aux) * 1.0E-6);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isDisplayed = nbt.func_74767_n("Disp");
        this.turbine = nbt.func_74762_e("turbine");
        this.height = nbt.func_74762_e("H");
        this.lenght = nbt.func_74762_e("L");
        this.getInv().readFromNBT(nbt);
        this.tracer = nbt.func_74762_e("Tracer");
        this.efficiency = nbt.func_74762_e("Eff");
        this.rayTrace = nbt.func_74770_j("rayTrace");
        if (this.rayTrace.length != 289) {
            this.rayTrace = null;
        }
        this.turbinePotency = nbt.func_74769_h("P");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("Disp", this.isDisplayed);
        nbt.func_74768_a("turbine", this.turbine);
        this.getInv().writeToNBT(nbt);
        nbt.func_74768_a("Tracer", this.tracer);
        nbt.func_74768_a("Eff", this.efficiency);
        if (this.rayTrace != null) {
            nbt.func_74773_a("rayTrace", this.rayTrace);
        }
        nbt.func_74768_a("H", this.height);
        nbt.func_74768_a("L", this.lenght);
        nbt.func_74780_a("P", this.turbinePotency);
    }

    @Override
    public IElectricConductor initConductor() {
        return new BufferedConductor(this, 0.01, 80000, 160.0, 180.0);
    }

    @Override
    public InventoryComponent getInv() {
        return this.inv;
    }

    public int getWindScaled(int i) {
        return (int)Math.min((double)i, (double)i * this.wind / 13333.0);
    }

    @Override
    public void sendGUINetworkData(Container cont, ICrafting craft) {
        craft.func_71112_a(cont, 0, (int)this.cond.getVoltage());
        craft.func_71112_a(cont, 1, this.cond.getStorage());
        craft.func_71112_a(cont, 2, (int)this.production);
        craft.func_71112_a(cont, 3, (int)this.productionPerSecond);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        if (id == 0) {
            this.cond.setVoltage(value);
        }
        if (id == 1) {
            this.cond.setStorage(value);
        }
        if (id == 2) {
            this.production = value;
        }
        if (id == 3) {
            this.productionPerSecond = value;
        }
    }

    public float getTurbineScale() {
        ItemStack a = this.getInv().func_70301_a(0);
        if (a != null && a.func_77973_b() instanceof IWindTurbine) {
            return ((IWindTurbine)a.func_77973_b()).getScale();
        }
        return 1.0f;
    }

    public IEnergyTracker getEnergyTracker() {
        return new IEnergyTracker(){

            @Override
            public float getMaxChange() {
                if (TileWindTurbine.this.turbinePotency != 0.0) {
                    return (float)(1333.0 * TileWindTurbine.this.turbinePotency);
                }
                return 1.0f;
            }

            @Override
            public float getChangeInTheLastTick() {
                if (TileWindTurbine.this.turbinePotency != 0.0) {
                    return TileWindTurbine.this.production;
                }
                return 0.0f;
            }

            @Override
            public float getChangeInTheLastSecond() {
                if (TileWindTurbine.this.turbinePotency != 0.0) {
                    return TileWindTurbine.this.productionPerSecond;
                }
                return 0.0f;
            }

            @Override
            public boolean isConsume() {
                return false;
            }
        };
    }

    public void onTurbineBreaks() {
        this.desactivateTurbine();
        if (this.turbine == -1) {
            return;
        }
        Random rand = this.field_145850_b.field_73012_v;
        ItemStack i = this.getInv().func_70301_a(0);
        this.getInv().func_70299_a(0, null);
        this.turbine = -1;
        if (i != null && i.field_77994_a > 0) {
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + rx), (double)((float)this.field_145848_d + ry), (double)((float)this.field_145849_e + rz), new ItemStack(i.func_77973_b(), i.field_77994_a, i.func_77960_j()));
            if (i.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)i.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            this.field_145850_b.func_72838_d((Entity)entityItem);
            this.sendUpdateToClient();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int func_70302_i_() {
        return this.getInv().func_70302_i_();
    }

    public ItemStack func_70301_a(int s) {
        return this.getInv().func_70301_a(s);
    }

    public ItemStack func_70304_b(int a) {
        return this.getInv().func_70304_b(a);
    }

    public String func_145825_b() {
        return this.getInv().func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.getInv().func_145818_k_();
    }

    public int func_70297_j_() {
        return this.getInv().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int a, ItemStack b) {
        return this.getInv().func_94041_b(a, b);
    }

    public IBarProvider getEfficiencyBar() {
        return new IBarProvider(){

            @Override
            public String getMessage() {
                return null;
            }

            @Override
            public float getMaxLevel() {
                return 1.0f;
            }

            @Override
            public float getLevel() {
                return (float)TileWindTurbine.this.efficiency / 5780.0f;
            }
        };
    }
}

